/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyJoinColumn;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.PluralProperty;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.converter.EntityConverter;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;

public class MapProperty<E, K, T>
extends PluralProperty<E, Map<K, T>, T> {
    private final Class<K> keyClass;
    private final EntityClass<K> keyEntityClass;
    private final ValueConverter<K> keyConverter;
    private final GeneratorColumn keyColumn;

    private static GeneratorColumn buildKeyColumn(GeneratorTable table, MapKeyColumn keyColumn, String defaultKeyColumn) {
        if (keyColumn != null && keyColumn.name().length() > 0) {
            return table.resolveColumn(keyColumn.name());
        }
        return table.resolveColumn(defaultKeyColumn);
    }

    private static GeneratorColumn buildKeyColumn(GeneratorTable table, MapKeyJoinColumn keyColumn, String defaultKeyColumn) {
        if (keyColumn != null && keyColumn.name().length() > 0) {
            return table.resolveColumn(keyColumn.name());
        }
        return table.resolveColumn(defaultKeyColumn);
    }

    static boolean isMapProperty(AttributeAccessor attribute) {
        return Map.class.isAssignableFrom(attribute.getType()) && MapProperty.hasPluralAnnotation(attribute);
    }

    public MapProperty(EntityClass<?> sourceClass, AttributeAccessor attribute, AssociationOverride override) {
        super(sourceClass, attribute, override, 1);
        MapKeyClass keyClassAnnotation = attribute.getAnnotation(MapKeyClass.class);
        this.keyClass = MapProperty.getPropertyArgument(attribute, keyClassAnnotation != null ? keyClassAnnotation.value() : Void.TYPE, 0);
        this.keyEntityClass = sourceClass.getContext().getDescription(this.keyClass);
        if (this.getMappedBy() != null) {
            this.keyConverter = null;
            this.keyColumn = null;
        } else if (this.keyEntityClass != null) {
            this.keyConverter = null;
            this.keyColumn = MapProperty.buildKeyColumn(this.getTable(), attribute.getAnnotation(MapKeyJoinColumn.class), attribute.getName() + "_KEY");
        } else {
            this.keyConverter = sourceClass.getContext().getProvider().createConverter(attribute, this.keyClass, true);
            this.keyColumn = MapProperty.buildKeyColumn(this.getTable(), attribute.getAnnotation(MapKeyColumn.class), attribute.getName() + "_KEY");
        }
    }

    @Override
    public void createPostInsertStatements(StatementsWriter writer, E entity) throws IOException {
        if (this.getMappedBy() == null) {
            ColumnExpression sourceId = EntityConverter.getEntityReference(entity, this.getMappedId(), this.getContext(), false);
            for (Map.Entry entry : this.getValue((Object)entity).entrySet()) {
                ColumnExpression key = entry.getKey() == null ? PrimitiveColumnExpression.NULL : (this.keyEntityClass != null ? EntityConverter.getEntityReference(entry.getKey(), this.getMappedId(), this.getContext(), false) : this.keyConverter.getExpression(entry.getKey(), this.getContext()));
                this.createValueStatement(writer, entity, sourceId, key, entry.getValue());
            }
        }
    }

    @Override
    public Collection<?> findReferencedEntities(E entity) {
        ArrayList<Object> entities;
        Collection<Object> keyEntities = Collections.emptyList();
        Collection<Object> valueEntities = Collections.emptyList();
        if (this.keyEntityClass != null) {
            keyEntities = this.getValue((Object)entity).keySet();
        }
        if (this.isEntityReference()) {
            valueEntities = this.getValue((Object)entity).values();
        } else if (this.isEmbedded()) {
            entities = new ArrayList<Object>();
            for (Object value : this.getValue((Object)entity).values()) {
                for (Property property : this.getEmbeddedProperties()) {
                    entities.addAll(property.findReferencedEntities(value));
                }
            }
            valueEntities = entities;
        }
        if (keyEntities.isEmpty()) {
            return valueEntities;
        }
        if (valueEntities.isEmpty()) {
            return keyEntities;
        }
        entities = new ArrayList(keyEntities.size() + valueEntities.size());
        entities.addAll(keyEntities);
        entities.addAll(valueEntities);
        return entities;
    }

    @Override
    public Map<K, T> getValue(E entity) {
        Map value = (Map)super.getValue(entity);
        return value == null ? Collections.EMPTY_MAP : value;
    }

    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    public EntityClass<K> getKeyEntityClass() {
        return this.keyEntityClass;
    }

    public ValueConverter<K> getKeyConverter() {
        return this.keyConverter;
    }

    @Override
    public GeneratorColumn getKeyColumn() {
        return this.keyColumn;
    }
}

