/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import java.beans.ConstructorProperties;
import javax.persistence.AttributeConverter;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public class CustomValueConverter<T, C>
implements ValueConverter<T> {
    private final AttributeConverter<T, C> customConverter;
    private final ValueConverter<C> valueConverter;

    @Override
    public ColumnExpression getExpression(T value, GeneratorContext context) {
        Object databaseValue = this.customConverter.convertToDatabaseColumn(value);
        if (databaseValue == null) {
            return PrimitiveColumnExpression.NULL;
        }
        return this.valueConverter.getExpression(databaseValue, context);
    }

    @ConstructorProperties(value={"customConverter", "valueConverter"})
    public CustomValueConverter(AttributeConverter<T, C> customConverter, ValueConverter<C> valueConverter) {
        this.customConverter = customConverter;
        this.valueConverter = valueConverter;
    }
}

