/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MapKeyEnumerated;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public class EnumConverter<E extends Enum<E>>
implements ValueConverter<E> {
    private final Class<E> targetType;
    private final EnumType exportType;

    public EnumConverter(AttributeAccessor attribute, Class<E> targetType, boolean mapKey) {
        this.targetType = targetType;
        EnumType enumType = EnumType.ORDINAL;
        if (mapKey) {
            MapKeyEnumerated enumerated = attribute.getAnnotation(MapKeyEnumerated.class);
            if (enumerated != null) {
                enumType = enumerated.value();
            }
        } else {
            Enumerated enumerated = attribute.getAnnotation(Enumerated.class);
            if (enumerated != null) {
                enumType = enumerated.value();
            }
        }
        this.exportType = enumType;
    }

    @Override
    public ColumnExpression getExpression(E value, GeneratorContext context) {
        switch (this.exportType) {
            case STRING: {
                return PrimitiveColumnExpression.create(((Enum)value).name(), context.getDialect());
            }
        }
        return PrimitiveColumnExpression.create(((Enum)value).ordinal(), context.getDialect());
    }

    @Override
    public ColumnExpression getExpression(String defaultValue, GeneratorContext context) {
        return this.getExpression(Enum.valueOf(this.targetType, defaultValue), context);
    }
}

