/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public class SerializableConverter
implements ValueConverter<Serializable> {
    private static final int DEFAULT_BUFFER_SIZE = 512;

    @Override
    public ColumnExpression getExpression(Serializable value, GeneratorContext context) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
            try (ObjectOutputStream stream = new ObjectOutputStream(buffer);){
                stream.writeObject(value);
            }
            return new PrimitiveColumnExpression<byte[]>(buffer.toByteArray(), context.getDialect()::createBlobExpression);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

