/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import java.beans.ConstructorProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.AbstractStatementsWriter;
import org.fastnate.generator.statements.EntityStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStatementsWriter
extends AbstractStatementsWriter {
    private static final Logger log = LoggerFactory.getLogger(FileStatementsWriter.class);
    public static final String OUTPUT_FILE_KEY = "fastnate.data.sql.output.file";
    public static final String OUTPUT_ENCODING_KEY = "fastnate.data.sql.output.encoding";
    private final Writer writer;
    private String statementSeparator = ";\n";
    private int statementsCount;

    protected static File ensureDirectoryExists(File outputFile) {
        File parentFile = outputFile.getAbsoluteFile().getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        return outputFile;
    }

    public FileStatementsWriter(File file) throws FileNotFoundException {
        this(file, StandardCharsets.UTF_8);
    }

    public FileStatementsWriter(File file, Charset encoding) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileStatementsWriter.ensureDirectoryExists(file)), encoding)));
    }

    public FileStatementsWriter(GeneratorContext context) throws FileNotFoundException {
        this(new File(context.getSettings().getProperty(OUTPUT_FILE_KEY, "data.sql")), Charset.forName(context.getSettings().getProperty(OUTPUT_ENCODING_KEY, "UTF-8")));
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        log.info("{} statements written", (Object)this.statementsCount);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(String statements) throws IOException {
        this.writer.write(statements);
    }

    @Override
    public void writeComment(String comment) throws IOException {
        this.writer.write("/* " + comment + " */\n");
    }

    @Override
    public void writePlainStatement(GeneratorDialect dialect, String sql) throws IOException {
        this.writer.write(sql);
        if (!sql.endsWith(this.statementSeparator)) {
            this.writer.write(this.statementSeparator);
        }
        ++this.statementsCount;
    }

    @Override
    public void writeSectionSeparator() throws IOException {
        this.writer.write(10);
    }

    @Override
    public void writeStatement(EntityStatement statement) throws IOException {
        this.writer.write(statement.toSql());
        this.writer.write(this.statementSeparator);
        ++this.statementsCount;
    }

    @ConstructorProperties(value={"writer"})
    public FileStatementsWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getStatementSeparator() {
        return this.statementSeparator;
    }

    public void setStatementSeparator(String statementSeparator) {
        this.statementSeparator = statementSeparator;
    }

    public int getStatementsCount() {
        return this.statementsCount;
    }
}

