/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Time;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.fastnate.generator.RelativeDate;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.AbstractStatementsWriter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.CurrentSequenceValueExpression;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.NextSequenceValueExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.SequenceValueExpression;

public class LiquibaseStatementsWriter
extends AbstractStatementsWriter {
    public static final String OUTPUT_FILE_KEY = "fastnate.liquibase.file";
    public static final String VERSION_KEY = "fastnate.liquibase.version";
    private static final RelativeDate.Precision[] DATE_PRECISIONS = new RelativeDate.Precision[]{RelativeDate.YEARS, RelativeDate.DAYS, RelativeDate.HOURS, RelativeDate.MINUTES};
    private static final FastDateFormat ISO_DATETIMESECONDS_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final XMLStreamWriter writer;
    private final boolean relativeDatesSupported;
    private OutputStream outputStream;
    private String changeSetId = "change";
    private String changeSetAuthour = "Unknown";
    private String changeSetComment = "Created by Fastnate";
    private boolean changeSetStarted;

    public LiquibaseStatementsWriter(GeneratorContext context) throws XMLStreamException, FileNotFoundException {
        this(new BufferedOutputStream(new FileOutputStream(context.getSettings().getProperty(OUTPUT_FILE_KEY, "changelog.xml"))), context.getSettings().getProperty(VERSION_KEY, "2.0"));
    }

    public LiquibaseStatementsWriter(OutputStream outputStream, String version) throws XMLStreamException {
        this(XMLOutputFactory.newFactory().createXMLStreamWriter(outputStream), version);
        this.outputStream = outputStream;
    }

    public LiquibaseStatementsWriter(XMLStreamWriter writer, String version) throws XMLStreamException {
        this.writer = writer;
        writer.writeStartDocument();
        writer.writeCharacters("\n");
        writer.writeStartElement("databaseChangeLog");
        String namespace = "http://www.liquibase.org/xml/ns/dbchangelog";
        if (version.matches("1\\..*")) {
            namespace = namespace + "/" + version;
        }
        writer.writeDefaultNamespace(namespace);
        writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", namespace + " http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-" + version + ".xsd");
        this.relativeDatesSupported = !version.matches("[1-3]\\..*");
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.changeSetStarted) {
                this.writer.writeCharacters("\n\t");
                this.writer.writeEndElement();
                this.changeSetStarted = false;
            }
            this.writer.writeCharacters("\n");
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.close();
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void ensureChangeSetStarted() throws XMLStreamException {
        if (!this.changeSetStarted) {
            this.writer.writeCharacters("\n\t");
            this.writer.writeStartElement("changeSet");
            this.writer.writeAttribute("id", this.changeSetId);
            this.writer.writeAttribute("author", this.changeSetAuthour);
            if (this.changeSetComment != null) {
                this.writer.writeCharacters("\n\t\t");
                this.writer.writeStartElement("comment");
                this.writer.writeCharacters(this.changeSetComment);
                this.writer.writeEndElement();
            }
            this.changeSetStarted = true;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public void startNextChangeSet(String id, String author, String comment) throws XMLStreamException {
        if (this.changeSetStarted) {
            this.writer.writeCharacters("\n\t");
            this.writer.writeEndElement();
            this.changeSetStarted = false;
        }
        this.changeSetId = id;
        this.changeSetAuthour = author;
        this.changeSetComment = comment;
    }

    private void writeColumnExpression(ColumnExpression expression) throws XMLStreamException {
        if (expression instanceof PrimitiveColumnExpression) {
            this.writePrimitiveExpression((PrimitiveColumnExpression)expression);
        } else if (expression instanceof SequenceValueExpression) {
            this.writeSequenceExpression((SequenceValueExpression)expression);
        } else {
            this.writer.writeAttribute("valueComputed", expression.toSql());
        }
    }

    @Override
    public void writeComment(String comment) throws IOException {
        try {
            if (this.changeSetStarted) {
                this.writer.writeCharacters("\n\t\t");
            } else {
                this.writer.writeCharacters("\n\t");
            }
            this.writer.writeComment(' ' + comment + ' ');
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeDateExpression(ColumnExpression expression, java.util.Date value, java.util.Date databaseValue) throws XMLStreamException {
        if (value instanceof RelativeDate || value instanceof RelativeDate.ReferenceDate) {
            if (this.relativeDatesSupported) {
                if (value == RelativeDate.NOW) {
                    this.writer.writeAttribute("valueDate", "now");
                    return;
                }
                if (value == RelativeDate.TODAY) {
                    this.writer.writeAttribute("valueDate", "today");
                    return;
                }
                if (value instanceof RelativeDate) {
                    this.writeRelativeDateExpression(expression, value);
                    return;
                }
            }
            this.writer.writeAttribute("valueComputed", expression.toSql());
        } else if (databaseValue instanceof Time) {
            this.writer.writeAttribute("valueDate", DateFormatUtils.ISO_TIME_NO_T_FORMAT.format(databaseValue));
        } else if (databaseValue instanceof Date) {
            this.writer.writeAttribute("valueDate", DateFormatUtils.ISO_DATE_FORMAT.format(databaseValue));
        } else if (value.getTime() % RelativeDate.SECONDS.getMillis() == 0L) {
            this.writer.writeAttribute("valueDate", DateFormatUtils.ISO_DATETIME_FORMAT.format(databaseValue));
        } else {
            this.writer.writeAttribute("valueDate", ISO_DATETIMESECONDS_FORMAT.format(databaseValue));
        }
    }

    @Override
    public void writePlainStatement(GeneratorDialect dialect, String sql) throws IOException {
        try {
            this.ensureChangeSetStarted();
            this.writer.writeCharacters("\n\t\t");
            this.writer.writeStartElement("sql");
            this.writer.writeCharacters(sql);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writePrimitiveExpression(PrimitiveColumnExpression<?> expression) throws XMLStreamException {
        Object value = expression.getValue();
        if (value != null) {
            if (value instanceof String) {
                this.writeString(expression, (String)value);
            } else if (value instanceof Number) {
                this.writer.writeAttribute("valueNumeric", value.toString());
            } else if (value instanceof Boolean) {
                this.writer.writeAttribute("valueNumeric", Boolean.TRUE.equals(value) ? "1" : "0");
            } else if (value instanceof java.util.Date) {
                this.writeDateExpression(expression, (java.util.Date)value, (java.util.Date)expression.getDatabaseValue());
            } else {
                this.writer.writeAttribute("valueComputed", expression.toSql());
            }
        }
    }

    private void writeRelativeDateExpression(ColumnExpression expression, java.util.Date value) throws XMLStreamException {
        RelativeDate date = (RelativeDate)value;
        if (date.getReferenceDate() == RelativeDate.NOW) {
            RelativeDate.Precision minimumPrecision = date.getPrecision();
            RelativeDate.Precision precision = Stream.of(DATE_PRECISIONS).filter(p -> p.getMillis() <= minimumPrecision.getMillis()).findFirst().orElse(RelativeDate.MINUTES);
            this.writer.writeAttribute("valueDate", "now" + (date.getDifference() > -precision.getMillis() ? "+" : "") + date.getDifference() / precision.getMillis() + precision.getUnit() + "s");
        } else if (date.getReferenceDate() == RelativeDate.TODAY) {
            this.writer.writeAttribute("valueDate", "today" + (date.getDifference() > -RelativeDate.DAYS.getMillis() ? "+" : "") + date.getDifference() / RelativeDate.DAYS.getMillis());
        } else {
            this.writer.writeAttribute("valueComputed", expression.toSql());
        }
    }

    @Override
    public void writeSectionSeparator() throws IOException {
        try {
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeSequenceExpression(SequenceValueExpression expression) throws XMLStreamException {
        if (expression.getDifference() == 0L) {
            if (expression instanceof NextSequenceValueExpression) {
                this.writer.writeAttribute("valueSequenceNext", expression.getSequence().getQualifiedName());
                return;
            }
            if (expression instanceof CurrentSequenceValueExpression) {
                this.writer.writeAttribute("valueSequenceCurrent", expression.getSequence().getQualifiedName());
                return;
            }
        }
        this.writer.writeAttribute("valueComputed", expression.toSql());
    }

    @Override
    public void writeStatement(EntityStatement statement) throws IOException {
        if (statement instanceof AbstractStatementsWriter.InsertStatement) {
            try {
                AbstractStatementsWriter.InsertStatement insert = (AbstractStatementsWriter.InsertStatement)statement;
                if (insert.getValues().isEmpty()) {
                    this.writePlainStatement(null, insert.toSql());
                }
                this.ensureChangeSetStarted();
                this.writer.writeCharacters("\n\t\t");
                this.writer.writeStartElement("insert");
                this.writeTableStatement(insert);
                this.writer.writeCharacters("\n\t\t");
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        } else if (statement instanceof AbstractStatementsWriter.UpdateStatement) {
            try {
                this.ensureChangeSetStarted();
                AbstractStatementsWriter.UpdateStatement update = (AbstractStatementsWriter.UpdateStatement)statement;
                this.writer.writeCharacters("\n\t\t");
                this.writer.writeStartElement("update");
                this.writeTableStatement(update);
                this.writer.writeCharacters("\n\t\t\t");
                this.writer.writeStartElement("where");
                this.writer.writeCharacters(update.getIdColumn().getName());
                this.writer.writeCharacters(" = ");
                this.writer.writeCharacters(update.getIdValue().toSql());
                this.writer.writeEndElement();
                this.writer.writeCharacters("\n\t\t");
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        } else {
            this.writePlainStatement(null, statement.toSql());
        }
    }

    private void writeString(ColumnExpression expression, String value) throws XMLStreamException {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) >= ' ') continue;
            this.writer.writeAttribute("valueComputed", expression.toSql());
            return;
        }
        this.writer.writeAttribute("value", value);
    }

    private void writeTableStatement(AbstractStatementsWriter.AbstractTableStatement insert) throws XMLStreamException {
        if (insert.getTable().getCatalog() != null) {
            this.writer.writeAttribute("catalogName", insert.getTable().getCatalog());
        }
        if (insert.getTable().getSchema() != null) {
            this.writer.writeAttribute("schemaName", insert.getTable().getSchema());
        }
        this.writer.writeAttribute("tableName", insert.getTable().getName());
        for (Map.Entry<GeneratorColumn, ColumnExpression> entry : insert.getValues().entrySet()) {
            this.writer.writeCharacters("\n\t\t\t");
            this.writer.writeEmptyElement("column");
            this.writer.writeAttribute("name", entry.getKey().getName());
            this.writeColumnExpression(entry.getValue());
        }
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    public boolean isRelativeDatesSupported() {
        return this.relativeDatesSupported;
    }

    public String getChangeSetId() {
        return this.changeSetId;
    }

    public String getChangeSetAuthour() {
        return this.changeSetAuthour;
    }

    public String getChangeSetComment() {
        return this.changeSetComment;
    }

    public boolean isChangeSetStarted() {
        return this.changeSetStarted;
    }
}

