/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator;

import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fastnate.generator.context.EmbeddedProperty;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratedIdProperty;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.ConnectedStatementsWriter;
import org.fastnate.generator.statements.FileStatementsWriter;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public class EntitySqlGenerator
implements Closeable {
    private final GeneratorContext context;
    private final StatementsWriter writer;

    private static <E> boolean isPostponedInsert(List<Object> postInsertEntities, E entity) {
        boolean isPostInsert;
        int index = postInsertEntities.indexOf(entity);
        boolean bl = isPostInsert = index >= 0;
        if (isPostInsert && index == postInsertEntities.size() - 1) {
            throw new IllegalArgumentException("An entity requires another entity that itself requires the first one.");
        }
        return isPostInsert;
    }

    public EntitySqlGenerator(GeneratorContext context, Connection connection) throws SQLException {
        this(context, new ConnectedStatementsWriter(connection, context));
    }

    public EntitySqlGenerator(GeneratorContext context, Writer writer) {
        this(context, new FileStatementsWriter(writer));
    }

    @Override
    public void close() throws IOException {
        this.writeAlignmentStatements();
        this.writer.close();
    }

    protected <E> boolean findEntity(E entity) throws IOException {
        return false;
    }

    public void flush() throws IOException {
        this.writeAlignmentStatements();
        this.writer.flush();
    }

    public <E> void markExistingEntities(Iterable<E> entities) throws IOException {
        for (E entity : entities) {
            this.context.getDescription(entity).markExistingEntity(entity);
        }
    }

    public <E> void markExistingEntity(E entity, Number id) {
        ((GeneratedIdProperty)this.context.getDescription(entity).getIdProperty()).markReference(entity, id);
    }

    public <E> void write(E entity) throws IOException {
        this.write(entity, new ArrayList<Object>());
    }

    private <E> void write(E entity, List<Object> postponedEntities) throws IOException {
        EntityClass<E> classDescription = this.context.getDescription(entity);
        if (classDescription.isNew(entity)) {
            if (!this.findEntity(entity) && !EntitySqlGenerator.isPostponedInsert(postponedEntities, entity)) {
                postponedEntities.add(entity);
            }
            this.writeTableEntities(entity, postponedEntities, classDescription.getAllProperties());
            if (postponedEntities.remove(entity)) {
                this.writeInserts(entity, postponedEntities, classDescription, classDescription.getDiscriminator());
            }
        }
    }

    public <E> void write(Iterable<? extends E> entities) throws IOException {
        for (E entity : entities) {
            this.write(entity);
        }
    }

    public void writeAlignmentStatements() throws IOException {
        this.context.writeAlignmentStatements(this.writer);
    }

    public void writeComment(String comment) throws IOException {
        this.writer.writeComment(comment);
    }

    private <E> void writeInserts(E entity, List<Object> postponedEntities, EntityClass<E> classDescription, ColumnExpression discriminator) throws IOException {
        TableStatement stmt = this.writer.createInsertStatement(this.context.getDialect(), classDescription.getTable());
        if (classDescription.getJoinedParentClass() != null) {
            this.writeInserts(entity, postponedEntities, classDescription.getJoinedParentClass(), discriminator);
            stmt.setColumnValue(classDescription.getPrimaryKeyJoinColumn(), classDescription.getEntityReference(entity, null, false));
        } else {
            classDescription.getIdProperty().createPreInsertStatements(this.writer, entity);
            classDescription.getIdProperty().addInsertExpression(stmt, entity);
            if (discriminator != null) {
                stmt.setColumnValue(classDescription.getDiscriminatorColumn(), discriminator);
            }
        }
        for (Property<E, ?> property : classDescription.getAdditionalProperties()) {
            property.createPreInsertStatements(this.writer, entity);
            property.addInsertExpression(stmt, entity);
        }
        this.writer.writeStatement(stmt);
        classDescription.createPostInsertStatements(entity, this.writer);
        for (Property<E, ?> property : classDescription.getAllProperties()) {
            for (Object referencedEntity : property.findReferencedEntities(entity)) {
                if (referencedEntity == null || postponedEntities.contains(referencedEntity)) continue;
                this.write(referencedEntity, postponedEntities);
            }
            property.createPostInsertStatements(this.writer, entity);
        }
    }

    public void writePlainStatement(String statement) throws IOException {
        this.writer.writePlainStatement(this.context.getDialect(), statement);
    }

    public void writeSectionSeparator() throws IOException {
        this.writer.writeSectionSeparator();
    }

    private <E, T> void writeTableEntities(E entity, List<Object> postponedEntities, Collection<Property<? super E, ?>> properties) throws IOException {
        for (Property<E, ?> property : properties) {
            if (property instanceof EmbeddedProperty) {
                EmbeddedProperty embeddedProperty = (EmbeddedProperty)property;
                this.writeTableEntities(embeddedProperty.getValue(entity), postponedEntities, embeddedProperty.getEmbeddedProperties().values());
                continue;
            }
            if (!property.isTableColumn()) continue;
            for (Object value : property.findReferencedEntities(entity)) {
                if (postponedEntities.contains(value) && !property.isRequired()) continue;
                this.write(value, postponedEntities);
            }
        }
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public StatementsWriter getWriter() {
        return this.writer;
    }

    @ConstructorProperties(value={"context", "writer"})
    public EntitySqlGenerator(GeneratorContext context, StatementsWriter writer) {
        this.context = context;
        this.writer = writer;
    }
}

