/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fastnate.generator.context.ContextModelListener;
import org.fastnate.generator.context.DefaultContextModelListener;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.AbstractStatementsWriter;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.FileStatementsWriter;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlBulkWriter
extends FileStatementsWriter {
    private static final Logger log = LoggerFactory.getLogger(PostgreSqlBulkWriter.class);
    private final GeneratorContext context;
    private final ContextModelListener contextListener = new ContextListener();
    private final File directory;
    private final Charset encoding;
    private final Map<GeneratorTable, Integer> fileNumbers = new HashMap<GeneratorTable, Integer>();
    private final Map<GeneratorTable, Writer> bulkWriters = new HashMap<GeneratorTable, Writer>();
    private final List<File> generatedFiles = new ArrayList<File>();
    private int statementsCount;

    public PostgreSqlBulkWriter(GeneratorContext context) throws FileNotFoundException {
        this(context, new File(context.getSettings().getProperty("fastnate.data.sql.output.file", "data.sql")), Charset.forName(context.getSettings().getProperty("fastnate.data.sql.output.encoding", "UTF-8")));
    }

    public PostgreSqlBulkWriter(GeneratorContext context, File sqlFile) throws FileNotFoundException {
        this(context, sqlFile, StandardCharsets.UTF_8);
    }

    public PostgreSqlBulkWriter(GeneratorContext context, File sqlFile, Charset encoding) throws FileNotFoundException {
        this(context, PostgreSqlBulkWriter.ensureDirectoryExists(sqlFile).getAbsoluteFile().getParentFile(), new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sqlFile), encoding)), encoding);
        this.generatedFiles.add(sqlFile);
    }

    public PostgreSqlBulkWriter(GeneratorContext context, File directory, Writer writer, Charset encoding) {
        super(writer);
        this.context = context;
        this.context.addContextModelListener(this.contextListener);
        this.directory = directory;
        this.encoding = encoding;
    }

    @Override
    public void close() throws IOException {
        this.context.removeContextModelListener(this.contextListener);
        this.closeBulkWriters();
        this.getWriter().close();
        log.info("{} statements and {} files written", (Object)this.statementsCount, (Object)this.generatedFiles.size());
    }

    public void closeBulkWriter(GeneratorTable table) throws IOException {
        Writer writer = this.bulkWriters.remove(table);
        if (writer != null) {
            writer.close();
        }
    }

    private void closeBulkWriters() throws IOException {
        for (Writer bulkWriter : this.bulkWriters.values()) {
            bulkWriter.close();
        }
        this.bulkWriters.clear();
    }

    private Writer findBulkWriter(GeneratorTable generatorTable, GeneratorDialect dialect) throws IOException {
        Writer bulkWriter = this.bulkWriters.get(generatorTable);
        if (bulkWriter == null) {
            Integer number = this.fileNumbers.get(generatorTable);
            String fileName = generatorTable.getQualifiedName();
            if (number == null) {
                this.fileNumbers.put(generatorTable, 2);
            } else {
                fileName = fileName + '.' + number.toString();
                this.fileNumbers.put(generatorTable, number + 1);
            }
            File file = new File(this.directory, fileName + ".blk");
            this.write("COPY " + generatorTable.getQualifiedName() + " (" + generatorTable.getColumns().keySet().stream().collect(Collectors.joining(", ")) + ") FROM " + dialect.quoteString(file.getAbsolutePath()) + " WITH ENCODING " + dialect.quoteString(this.encoding.name().toLowerCase()) + this.getStatementSeparator());
            ++this.statementsCount;
            bulkWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding));
            this.bulkWriters.put(generatorTable, bulkWriter);
            this.generatedFiles.add(file);
        }
        return bulkWriter;
    }

    @Override
    public void flush() throws IOException {
        for (Writer bulkWriter : this.bulkWriters.values()) {
            bulkWriter.flush();
        }
        super.flush();
    }

    @Override
    public void writePlainStatement(GeneratorDialect dialect, String sql) throws IOException {
        this.writePlainStatement(sql);
    }

    private void writePlainStatement(String sql) throws IOException {
        if (!sql.startsWith("TRUNCATE ")) {
            this.closeBulkWriters();
        }
        this.write(sql);
        if (!sql.endsWith(this.getStatementSeparator())) {
            this.write(this.getStatementSeparator());
        }
        ++this.statementsCount;
    }

    @Override
    public void writeStatement(EntityStatement stmt) throws IOException {
        AbstractStatementsWriter.InsertStatement insert;
        if (stmt instanceof AbstractStatementsWriter.InsertStatement && !(insert = (AbstractStatementsWriter.InsertStatement)stmt).isPlainExpressionAvailable()) {
            Writer bulkWriter = this.findBulkWriter(insert.getTable(), insert.getDialect());
            boolean tab = false;
            for (GeneratorColumn column : insert.getTable().getColumns().values()) {
                if (column.isAutoGenerated()) continue;
                if (tab) {
                    bulkWriter.write(9);
                } else {
                    tab = true;
                }
                PrimitiveColumnExpression expression = (PrimitiveColumnExpression)insert.getValues().get(column);
                if (expression == null) {
                    bulkWriter.write("\\N");
                    continue;
                }
                Object value = expression.getDatabaseValue();
                if (value == null) {
                    bulkWriter.write("\\N");
                    continue;
                }
                if (value instanceof String) {
                    bulkWriter.write(((String)value).replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t"));
                    continue;
                }
                bulkWriter.write(value.toString());
            }
            bulkWriter.write(10);
            ++this.statementsCount;
            return;
        }
        this.writePlainStatement(stmt.toSql());
    }

    public File getDirectory() {
        return this.directory;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public List<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    @Override
    public int getStatementsCount() {
        return this.statementsCount;
    }

    private final class ContextListener
    extends DefaultContextModelListener {
        @Override
        public void foundColumn(GeneratorColumn column) {
            try {
                PostgreSqlBulkWriter.this.closeBulkWriter(column.getTable());
            }
            catch (IOException e) {
                throw new ModelException("Could not close the writer for " + column.getTable(), e);
            }
        }
    }
}

