/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator;

import java.util.Date;
import lombok.Generated;

public class RelativeDate
extends Date {
    private static final long serialVersionUID = 1L;
    public static final ReferenceDate TODAY = new ReferenceDate(System.currentTimeMillis() - 2L);
    public static final ReferenceDate NOW = new ReferenceDate(System.currentTimeMillis() - 1L);
    public static final Precision MILLISECONDS = new Precision("MILLISECOND", 1L);
    public static final Precision SECONDS = new Precision("SECOND", 1000L);
    public static final Precision MINUTES = new Precision("MINUTE", 60000L);
    public static final Precision HOURS = new Precision("HOUR", 3600000L);
    public static final Precision DAYS = new Precision("DAY", 86400000L);
    public static final Precision WEEKS = new Precision("WEEK", 604800000L);
    public static final Precision YEARS = new Precision("YEAR", 31536000000L);
    private static final Precision[] PRECISIONS = new Precision[]{MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS, WEEKS, YEARS};
    private final ReferenceDate referenceDate;

    public RelativeDate(long timeInMillis) {
        super(timeInMillis);
        this.referenceDate = NOW;
    }

    public RelativeDate(ReferenceDate referenceDate, long deltaInMillis) {
        super(deltaInMillis + referenceDate.getTime());
        this.referenceDate = referenceDate;
    }

    public RelativeDate(ReferenceDate referenceDate, long delta, Precision precision) {
        super(referenceDate.getTime() + delta * precision.getMillis());
        this.referenceDate = referenceDate;
    }

    public long getDifference() {
        return this.getTime() - this.referenceDate.getTime();
    }

    public Precision getPrecision() {
        Precision precision;
        long difference = this.getTime() - this.referenceDate.getTime();
        Precision previousPrecision = PRECISIONS[0];
        for (int i = 1; i < PRECISIONS.length && difference % (precision = PRECISIONS[i]).getMillis() == 0L; ++i) {
            previousPrecision = precision;
        }
        return previousPrecision;
    }

    @Generated
    public ReferenceDate getReferenceDate() {
        return this.referenceDate;
    }

    public static final class ReferenceDate
    extends Date {
        private static final long serialVersionUID = 1L;

        ReferenceDate(long timeInMillis) {
            super(timeInMillis);
        }

        @Override
        public void setDate(int date) {
            throw new UnsupportedOperationException("Can't change a reference date");
        }

        @Override
        public void setHours(int hours) {
            throw new UnsupportedOperationException("Can't change a reference date");
        }

        @Override
        public void setMinutes(int minutes) {
            throw new UnsupportedOperationException("Can't change a reference date");
        }

        @Override
        public void setMonth(int month) {
            throw new UnsupportedOperationException("Can't change a reference date");
        }

        @Override
        public void setSeconds(int seconds) {
            throw new UnsupportedOperationException("Can't change a reference date");
        }

        @Override
        public void setTime(long time) {
            throw new UnsupportedOperationException("Can't change a reference date");
        }

        @Override
        public void setYear(int year) {
            throw new UnsupportedOperationException("Can't change a reference date");
        }
    }

    public static final class Precision {
        private final String unit;
        private final long millis;

        public String toString() {
            return this.unit;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public long getMillis() {
            return this.millis;
        }

        @Generated
        Precision(String unit, long millis) {
            this.unit = unit;
            this.millis = millis;
        }
    }
}

