/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.converter.BooleanConverter;
import org.fastnate.generator.converter.NumberConverter;
import org.fastnate.generator.converter.StringConverter;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.TableStatement;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.AnyMetaDefs;
import org.hibernate.annotations.MetaValue;

public class AnyMapping<T> {
    private static final Map<String, Supplier<? extends ValueConverter<?>>> META_TYPES = new HashMap();
    private final GeneratorColumn column;
    private final Map<Class<?>, ColumnExpression> anyClasses = new HashMap();

    private static AnyMetaDef findElementMetaDef(AnnotatedElement element, String metaDefName) {
        AnyMetaDef metaDef = element.getAnnotation(AnyMetaDef.class);
        if (metaDef != null && metaDefName.equals(metaDef.name())) {
            return metaDef;
        }
        AnyMetaDefs metaDefs = element.getAnnotation(AnyMetaDefs.class);
        if (metaDefs != null) {
            for (AnyMetaDef metaDefsValue : metaDefs.value()) {
                if (!metaDefName.equals(metaDefsValue.name())) continue;
                return metaDefsValue;
            }
        }
        return null;
    }

    public AnyMapping(GeneratorContext context, AttributeAccessor attribute, GeneratorTable containerTabble, Column typeColumn, String metaDefName) {
        this.column = containerTabble.resolveColumn(typeColumn.name());
        this.fillMetaDefs(attribute, typeColumn, metaDefName, context);
    }

    private void fillMetaDefs(AttributeAccessor attribute, Column typeColumn, String metaDefName, GeneratorContext context) {
        AnyMetaDef metaDef;
        if (metaDefName != null && metaDefName.length() > 0) {
            metaDef = this.findGlobalMetaDef(attribute, metaDefName);
            ModelException.mustExist(metaDef, "Can't find AnyMetaDef with name {} for {} in the class hierarchy", metaDefName, attribute);
        } else {
            metaDef = attribute.getAnnotation(AnyMetaDef.class);
            ModelException.mustExist(metaDef, "Missing AnyMetaDef annotation for {}", attribute);
        }
        ValueConverter converter = META_TYPES.getOrDefault(metaDef.metaType(), () -> new StringConverter(typeColumn, !attribute.isAnnotationPresent(NotNull.class))).get();
        HashSet<String> duplicates = new HashSet<String>();
        for (MetaValue metaValue : metaDef.metaValues()) {
            ModelException.test(this.anyClasses.put(metaValue.targetEntity(), converter.getExpression(metaValue.value(), context)) == null, "The class {} is defined twice for AnyMetaDef assigned to {}", metaValue.targetEntity(), attribute);
            ModelException.test(duplicates.add(metaValue.value()), "The value {} is defined twice for AnyMetaDef assigned to {}", metaValue.value(), attribute);
        }
    }

    private ColumnExpression findDesc(T entity) {
        ColumnExpression desc = this.anyClasses.get(entity.getClass());
        ModelException.mustExist(desc, "Missing AnyMetaDef for {}", entity.getClass());
        return desc;
    }

    private AnyMetaDef findGlobalMetaDef(AttributeAccessor attribute, String metaDefName) {
        AnyMetaDef metaDef = AnyMapping.findElementMetaDef(attribute, metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        metaDef = this.findMetaDefInClassHierarchy(attribute.getDeclaringClass(), metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        return this.findMetaDefInClassHierarchy(attribute.getType(), metaDefName);
    }

    private AnyMetaDef findMetaDefInClassHierarchy(Class<?> entityClass, String metaDefName) {
        if (entityClass == null || entityClass == Object.class) {
            return null;
        }
        AnyMetaDef metaDef = AnyMapping.findElementMetaDef(entityClass, metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        metaDef = this.findMetaDefInPackageHierarchy(entityClass.getPackage(), metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        for (Class<?> interf : entityClass.getInterfaces()) {
            metaDef = this.findMetaDefInClassHierarchy(interf, metaDefName);
            if (metaDef == null) continue;
            return metaDef;
        }
        return Stream.concat(Stream.of(entityClass.getDeclaredFields()), Stream.of(entityClass.getDeclaredMethods())).map(element -> AnyMapping.findElementMetaDef(element, metaDefName)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.findMetaDefInClassHierarchy(entityClass.getSuperclass(), metaDefName));
    }

    private AnyMetaDef findMetaDefInPackageHierarchy(Package classPackage, String metaDefName) {
        if (classPackage == null) {
            return null;
        }
        AnyMetaDef metaDef = AnyMapping.findElementMetaDef(classPackage, metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        String packageName = classPackage.getName();
        int lastDot = packageName.lastIndexOf(46);
        while (lastDot > 0) {
            Package parentPackage = Package.getPackage(packageName.substring(0, lastDot));
            if (parentPackage != null) {
                return this.findMetaDefInPackageHierarchy(parentPackage, metaDefName);
            }
            lastDot = packageName.lastIndexOf(46, lastDot - 1);
        }
        return null;
    }

    public String getPredicate(T value) {
        if (value == null) {
            return this.column.getQualifiedName() + " IS NULL";
        }
        return this.column.getQualifiedName() + " = " + this.findDesc(value);
    }

    public void setColumnValue(TableStatement statement, T value) {
        if (value == null) {
            statement.setColumnValue(this.column, PrimitiveColumnExpression.NULL);
        }
        statement.setColumnValue(this.column, this.findDesc(value));
    }

    @Generated
    public GeneratorColumn getColumn() {
        return this.column;
    }

    static {
        META_TYPES.put("boolean", BooleanConverter::new);
        META_TYPES.put("byte", () -> new NumberConverter(Byte.class));
        META_TYPES.put("short", () -> new NumberConverter(Short.class));
        META_TYPES.put("integer", () -> new NumberConverter(Integer.class));
        META_TYPES.put("long", () -> new NumberConverter(Long.class));
        META_TYPES.put("float", () -> new NumberConverter(Float.class));
        META_TYPES.put("double", () -> new NumberConverter(Double.class));
    }
}

