/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.persistence.Access;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeOverride;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import lombok.Generated;
import org.fastnate.generator.context.AccessStyle;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public class EmbeddedProperty<E, T>
extends Property<E, T> {
    private final Map<String, Property<? super T, ?>> embeddedProperties = new TreeMap();
    private final boolean id;
    @Nonnull
    private final Constructor<T> constructor;

    public EmbeddedProperty(EntityClass<?> entityClass, GeneratorTable table, AttributeAccessor attribute, Map<String, AttributeOverride> surroundingAttributeOverrides, Map<String, AssociationOverride> surroundingAssociationOverrides) {
        super(attribute);
        this.id = attribute.isAnnotationPresent(EmbeddedId.class);
        Class<?> type = attribute.getType();
        if (!type.isAnnotationPresent(Embeddable.class)) {
            throw new IllegalArgumentException(attribute + " does reference " + type + " which is not embeddable.");
        }
        try {
            this.constructor = type.getDeclaredConstructor(new Class[0]);
            if (!Modifier.isPublic(this.constructor.getModifiers())) {
                this.constructor.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            throw new ModelException("Could not find constructor without arguments for " + type);
        }
        Access accessType = type.getAnnotation(Access.class);
        AccessStyle accessStyle = accessType != null ? AccessStyle.getStyle(accessType.value()) : attribute.getAccessStyle();
        String prefix = attribute.getName() + '.';
        Map<String, AttributeOverride> attributeOverrides = EntityClass.getAttributeOverrides(surroundingAttributeOverrides, prefix, attribute.getElement());
        Map<String, AssociationOverride> associationOverrides = EntityClass.getAccociationOverrides(surroundingAssociationOverrides, prefix, attribute.getElement());
        for (AttributeAccessor embeddedAttribute : accessStyle.getDeclaredAttributes(type, type)) {
            Property property = entityClass.buildProperty(table, embeddedAttribute, attributeOverrides, associationOverrides);
            if (property == null) continue;
            this.embeddedProperties.put(embeddedAttribute.getName(), property);
        }
    }

    @Override
    public void addInsertExpression(TableStatement statement, E entity) {
        Object value = this.getValue(entity);
        if (value != null) {
            for (Property<T, ?> property : this.embeddedProperties.values()) {
                property.addInsertExpression(statement, value);
            }
        } else {
            this.failIfRequired(entity);
        }
    }

    @Override
    public void createPostInsertStatements(StatementsWriter writer, E entity) throws IOException {
        Object value = this.getValue(entity);
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            property.createPostInsertStatements(writer, value);
        }
    }

    @Override
    public void createPreInsertStatements(StatementsWriter writer, E entity) throws IOException {
        Object value = this.getValue(entity);
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            property.createPreInsertStatements(writer, value);
        }
    }

    @Override
    public Collection<?> findReferencedEntities(E entity) {
        Object value = this.getValue(entity);
        HashSet result = new HashSet();
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            result.addAll(property.findReferencedEntities(value));
        }
        return result;
    }

    public T getInitializedValue(E entity) {
        Object value = this.getValue(entity);
        if (value == null) {
            try {
                value = this.constructor.newInstance(new Object[0]);
                this.setValue(entity, value);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        return value;
    }

    @Override
    public String getPredicate(E entity) {
        if (this.embeddedProperties.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder().append('(');
        Object value = this.getValue(entity);
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            if (result.length() > 1) {
                result.append(" AND ");
            }
            result.append(property.getPredicate(value));
        }
        return result.append(")").toString();
    }

    @Override
    public boolean isRequired() {
        if (this.id) {
            return true;
        }
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            if (!property.isRequired()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTableColumn() {
        return true;
    }

    @Generated
    public Map<String, Property<? super T, ?>> getEmbeddedProperties() {
        return this.embeddedProperties;
    }

    @Generated
    public boolean isId() {
        return this.id;
    }
}

