/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import lombok.Generated;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.PrimitiveProperty;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;
import org.fastnate.util.ClassUtil;

public class GeneratedIdProperty<E, T extends Number>
extends PrimitiveProperty<E, T> {
    private final boolean absoluteIds;
    private final boolean primitive;
    private final EntityClass<E> entityClass;
    private final Class<T> type;
    private final T unknownIdMarker;
    private final IdGenerator generator;

    public GeneratedIdProperty(EntityClass<E> entityClass, AttributeAccessor attribute, Column column) {
        super(entityClass.getContext(), entityClass.getTable(), attribute, column, entityClass.getContext().isWriteRelativeIds() || !entityClass.getContext().getDialect().isSettingIdentityAllowed());
        this.entityClass = entityClass;
        this.absoluteIds = !this.getColumn().isAutoGenerated();
        this.type = attribute.getType();
        this.unknownIdMarker = ClassUtil.convertNumber(-1, this.type);
        this.primitive = this.type.isPrimitive();
        this.generator = entityClass.getContext().getGenerator(attribute.getAnnotation(GeneratedValue.class), this.getTable(), this.getColumn());
    }

    @Override
    public void addInsertExpression(TableStatement statement, E entity) {
        this.ensureIsNew(entity);
        if (this.absoluteIds) {
            T id = this.generator.createNextValue(this.type);
            this.setValue(entity, id);
            statement.setColumnValue(this.getColumn(), PrimitiveColumnExpression.create(id, this.getDialect()));
        } else if (!this.generator.isPostIncrement()) {
            T id = this.generator.createNextValue(this.type);
            this.setValue(entity, id);
            this.generator.addNextValue(statement, this.getColumn(), (Number)id);
        }
    }

    @Override
    public void createPreInsertStatements(StatementsWriter writer, E entity) throws IOException {
        if (!this.absoluteIds) {
            this.generator.createPreInsertStatements(writer);
        }
    }

    private void ensureIsNew(E entity) {
        if (!this.isNew(entity)) {
            throw new IllegalArgumentException("Tried to create entity twice: " + entity);
        }
    }

    @Override
    public ColumnExpression getExpression(E entity, boolean whereExpression) {
        Number targetId = (Number)this.getValue(entity);
        if (targetId == null) {
            return null;
        }
        if (targetId == this.unknownIdMarker) {
            throw new IllegalArgumentException("Entity must be referenced by an unique property: " + entity);
        }
        if (targetId.longValue() < 0L) {
            return PrimitiveColumnExpression.create(-2L - targetId.longValue(), this.getDialect());
        }
        if (this.absoluteIds) {
            return PrimitiveColumnExpression.create(targetId, this.getDialect());
        }
        return this.generator.getExpression(this.getTable(), this.getColumn(), targetId, whereExpression);
    }

    public boolean isNew(E entity) {
        Number id = (Number)this.getValue(entity);
        return id == null || this.primitive && id.longValue() == 0L;
    }

    public boolean isReference(E entity) {
        Number id = (Number)this.getValue(entity);
        return id != null && id.longValue() < 0L;
    }

    public void markReference(E entity) {
        if (this.isNew(entity)) {
            this.setValue(entity, this.unknownIdMarker);
        }
    }

    public void markReference(E entity, T id) {
        if (this.isNew(entity)) {
            this.setValue(entity, ClassUtil.convertNumber(-2L - ((Number)id).longValue(), this.type));
        }
    }

    public void postInsert(E entity) {
        if (!this.absoluteIds && this.generator.isPostIncrement()) {
            this.setValue(entity, this.generator.createNextValue(this.type));
        }
    }

    @Generated
    public boolean isAbsoluteIds() {
        return this.absoluteIds;
    }

    @Generated
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Generated
    public EntityClass<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    @Generated
    public Class<T> getType() {
        return this.type;
    }

    @Generated
    public T getUnknownIdMarker() {
        return this.unknownIdMarker;
    }

    @Generated
    public IdGenerator getGenerator() {
        return this.generator;
    }
}

