/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.statements.StatementsWriter;

public class GenerationState {
    public static final GenerationState PERSISTED = new GenerationState();

    private GenerationState() {
    }

    public static final class PendingState
    extends GenerationState {
        private final List<Update<?>> updates = new ArrayList();

        public <E> void addPendingUpdate(E entity, Property<E, ?> property, Object ... arguments) {
            this.updates.add(new Update<E>(entity, property, arguments));
        }

        public <E> void writePendingStatements(StatementsWriter writer, Object entity) throws IOException {
            Iterator<Update<?>> iterator = this.updates.iterator();
            while (iterator.hasNext()) {
                Update<?> update;
                Update<?> singleUpdate = update = iterator.next();
                singleUpdate.getProperty().generatePendingStatements(writer, singleUpdate.getEntity(), entity, singleUpdate.getArguments());
            }
        }

        @Generated
        public List<Update<?>> getUpdates() {
            return this.updates;
        }

        @Generated
        public PendingState() {
        }

        private static final class Update<E> {
            private final E entity;
            private final Property<E, ?> property;
            private final Object[] arguments;

            @Generated
            public E getEntity() {
                return this.entity;
            }

            @Generated
            public Property<E, ?> getProperty() {
                return this.property;
            }

            @Generated
            public Object[] getArguments() {
                return this.arguments;
            }

            @Generated
            public Update(E entity, Property<E, ?> property, Object[] arguments) {
                this.entity = entity;
                this.property = property;
                this.arguments = arguments;
            }
        }
    }
}

