/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.AssociationOverride;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.JoinTable;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.generator.context.AnnotationDefaults;
import org.fastnate.generator.context.ContextModelListener;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GenerationState;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.IdentityValue;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.SequenceIdGenerator;
import org.fastnate.generator.context.TableIdGenerator;
import org.fastnate.generator.context.UniquePropertyQuality;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.dialect.H2Dialect;
import org.fastnate.generator.provider.HibernateProvider;
import org.fastnate.generator.provider.JpaProvider;
import org.fastnate.generator.statements.StatementsWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeneratorContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneratorContext.class);
    public static final String PROVIDER_KEY = "fastnate.generator.jpa.provider";
    public static final String PERSISTENCE_FILE_KEY = "fastnate.generator.persistence.file";
    public static final String PERSISTENCE_UNIT_KEY = "fastnate.generator.persistence.unit";
    public static final String DIALECT_KEY = "fastnate.generator.dialect";
    public static final String NULL_VALUES_KEY = "fastnate.generator.null.values";
    public static final String RELATIVE_IDS_KEY = "fastnate.generator.relative.ids";
    public static final String QUOTE_ALL_IDENTIFIERS_KEY = "fastnate.generator.quote.all.identifiers";
    public static final String UNIQUE_PROPERTIES_QUALITY_KEY = "fastnate.generator.unique.properties.quality";
    public static final String UNIQUE_PROPERTIES_MAX_KEY = "fastnate.generator.unique.properties.max";
    public static final String PREFER_SEQUENCE_CURRENT_VALUE = "fastnate.generator.prefer.sequence.current.value";
    private GeneratorDialect dialect;
    private JpaProvider provider;
    private int maxUniqueProperties = 1;
    private UniquePropertyQuality uniquePropertyQuality = UniquePropertyQuality.onlyRequiredPrimitives;
    private boolean preferSequenceCurentValue = true;
    private boolean writeRelativeIds;
    private boolean writeNullValues;
    private boolean quoteAllIdentifiers;
    private final Properties settings;
    private final Map<Class<?>, EntityClass<?>> descriptions = new HashMap();
    private final Map<String, EntityClass<?>> descriptionsByName = new HashMap();
    private final Map<String, GeneratorTable> tables = new HashMap<String, GeneratorTable>();
    private final Map<String, Map<Object, GenerationState>> states = new HashMap<String, Map<Object, GenerationState>>();
    private final Map<GeneratorId, IdGenerator> generators = new HashMap<GeneratorId, IdGenerator>();
    private SequenceIdGenerator defaultSequenceGenerator;
    private TableIdGenerator defaultTableGenerator;
    private List<ContextModelListener> contextModelListeners = new ArrayList<ContextModelListener>();

    private static void readPersistenceFile(Properties settings) {
        String persistenceFilePath = settings.getProperty(PERSISTENCE_FILE_KEY);
        if (StringUtils.isEmpty((CharSequence)persistenceFilePath)) {
            URL url = GeneratorContext.class.getResource("/META-INF/persistence.xml");
            if (url == null) {
                return;
            }
            persistenceFilePath = url.toString();
        } else {
            File persistenceFile = new File(persistenceFilePath);
            if (persistenceFile.isFile()) {
                persistenceFilePath = persistenceFile.toURI().toString();
            }
        }
        String persistenceUnit = settings.getProperty(PERSISTENCE_UNIT_KEY);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(persistenceFilePath);
            NodeList persistenceUnits = document.getElementsByTagName("persistence-unit");
            for (int i = 0; i < persistenceUnits.getLength(); ++i) {
                Element persistenceUnitElement = (Element)persistenceUnits.item(i);
                if (!StringUtils.isEmpty((CharSequence)persistenceUnit) && !persistenceUnit.equals(persistenceUnitElement.getAttribute("name"))) continue;
                NodeList properties = persistenceUnitElement.getElementsByTagName("property");
                for (int i2 = 0; i2 < properties.getLength(); ++i2) {
                    Element property = (Element)properties.item(i2);
                    String name = property.getAttribute("name");
                    if (settings.containsKey(name)) continue;
                    settings.put(name, property.getAttribute("value"));
                }
                break;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.error("Could not read " + persistenceFilePath + ": " + e, (Throwable)e);
        }
    }

    public GeneratorContext() {
        this(new H2Dialect());
    }

    public GeneratorContext(GeneratorDialect dialect) {
        this.dialect = dialect;
        this.provider = new HibernateProvider();
        this.settings = new Properties();
    }

    public GeneratorContext(Properties settings) {
        this.settings = settings;
        GeneratorContext.readPersistenceFile(settings);
        String providerName = settings.getProperty(PROVIDER_KEY, "HibernateProvider");
        if (providerName.indexOf(46) < 0) {
            providerName = JpaProvider.class.getPackage().getName() + '.' + providerName;
        }
        try {
            this.provider = (JpaProvider)Class.forName(providerName).newInstance();
            this.provider.initialize(settings);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate provider: " + providerName, e);
        }
        String dialectName = settings.getProperty(DIALECT_KEY, "H2Dialect");
        if (dialectName.indexOf(46) < 0 && !(dialectName = GeneratorDialect.class.getPackage().getName() + '.' + dialectName).endsWith("Dialect")) {
            dialectName = dialectName + "Dialect";
        }
        try {
            this.dialect = (GeneratorDialect)Class.forName(dialectName).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate dialect: " + dialectName, e);
        }
        this.writeRelativeIds = Boolean.parseBoolean(settings.getProperty(RELATIVE_IDS_KEY, String.valueOf(this.writeRelativeIds)));
        this.writeNullValues = Boolean.parseBoolean(settings.getProperty(NULL_VALUES_KEY, String.valueOf(this.writeNullValues)));
        this.quoteAllIdentifiers = Boolean.parseBoolean(settings.getProperty(QUOTE_ALL_IDENTIFIERS_KEY, String.valueOf(this.quoteAllIdentifiers)));
        this.uniquePropertyQuality = UniquePropertyQuality.valueOf(settings.getProperty(UNIQUE_PROPERTIES_QUALITY_KEY, this.uniquePropertyQuality.name()));
        this.maxUniqueProperties = Integer.parseInt(settings.getProperty(UNIQUE_PROPERTIES_MAX_KEY, String.valueOf(this.maxUniqueProperties)));
        this.preferSequenceCurentValue = Boolean.parseBoolean(settings.getProperty(PREFER_SEQUENCE_CURRENT_VALUE, String.valueOf(this.preferSequenceCurentValue)));
    }

    public void addContextModelListener(ContextModelListener listener) {
        this.contextModelListeners.add(listener);
    }

    private <K, T> T addContextObject(Map<K, ? super T> objects, BiConsumer<ContextModelListener, ? super T> listenerFunction, K key, T object) {
        objects.put(key, object);
        this.fireContextObjectAdded(listenerFunction, object);
        return object;
    }

    public String adjustIdentifier(String identifier) {
        char firstChar = identifier.charAt(0);
        int indexOfLastChar = identifier.length() - 1;
        if (firstChar == '\"' && identifier.charAt(indexOfLastChar) == '\"' || firstChar == '`' && identifier.charAt(indexOfLastChar) == '`') {
            return this.dialect.quoteIdentifier(identifier.substring(1, indexOfLastChar));
        }
        if (this.quoteAllIdentifiers) {
            return this.dialect.quoteIdentifier(identifier);
        }
        return identifier;
    }

    public String buildQualifiedName(String catalog, String schema, String objectName) {
        if (catalog == null || catalog.length() == 0) {
            if (schema == null || schema.length() == 0 || !this.dialect.isSchemaSupported()) {
                return this.adjustIdentifier(objectName);
            }
            return this.adjustIdentifier(schema) + '.' + this.adjustIdentifier(objectName);
        }
        if (schema == null || schema.length() == 0 || !this.dialect.isSchemaSupported()) {
            return this.adjustIdentifier(catalog) + '.' + this.adjustIdentifier(objectName);
        }
        return this.adjustIdentifier(catalog) + '.' + this.adjustIdentifier(schema) + '.' + this.adjustIdentifier(objectName);
    }

    protected <T> void fireContextObjectAdded(BiConsumer<ContextModelListener, T> listenerFunction, T contextObject) {
        for (ContextModelListener listener : this.contextModelListeners) {
            listenerFunction.accept(listener, (ContextModelListener)contextObject);
        }
    }

    private IdGenerator getDefaultSequenceGenerator() {
        if (this.defaultSequenceGenerator == null) {
            Map<String, Object> defaults = Stream.of(new AbstractMap.SimpleEntry<String, String>("sequenceName", this.provider.getDefaultSequence()), new AbstractMap.SimpleEntry<String, Integer>("allocationSize", 1)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            this.defaultSequenceGenerator = new SequenceIdGenerator(AnnotationDefaults.create(SequenceGenerator.class, defaults), this);
            this.fireContextObjectAdded(ContextModelListener::foundGenerator, this.defaultSequenceGenerator);
        }
        return this.defaultSequenceGenerator;
    }

    private IdGenerator getDefaultTableGenerator() {
        if (this.defaultTableGenerator == null) {
            Map<String, Object> defaults = Stream.of(new AbstractMap.SimpleEntry<String, String>("pkColumnValue", "default"), new AbstractMap.SimpleEntry<String, Integer>("allocationSize", 1)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            this.defaultTableGenerator = new TableIdGenerator(AnnotationDefaults.create(TableGenerator.class, defaults), this);
            this.fireContextObjectAdded(ContextModelListener::foundGenerator, this.defaultTableGenerator);
        }
        return this.defaultTableGenerator;
    }

    public <E> EntityClass<E> getDescription(Class<E> entityClass) {
        EntityClass<Object> description = this.descriptions.get(entityClass);
        if (description == null) {
            if (!entityClass.isAnnotationPresent(Entity.class)) {
                Class<E> superClass = entityClass.getSuperclass();
                if (superClass == null) {
                    return null;
                }
                return this.getDescription((E)superClass);
            }
            description = new EntityClass<E>(this, entityClass);
            this.descriptions.put(entityClass, description);
            this.descriptionsByName.put(description.getEntityName(), description);
            description.build();
            this.fireContextObjectAdded(ContextModelListener::foundEntityClass, description);
        }
        return description;
    }

    public <E> EntityClass<E> getDescription(E entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Can't inspect null entity");
        }
        EntityClass<Class<?>> description = this.getDescription((E)entity.getClass());
        if (description == null) {
            throw new IllegalArgumentException(entity.getClass() + " is not an entity class");
        }
        return description;
    }

    public IdGenerator getGenerator(GeneratedValue generatedValue, GeneratorTable table, GeneratorColumn column) {
        GenerationType strategy = generatedValue.strategy();
        String name = generatedValue.generator();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            ModelException.test(strategy != GenerationType.IDENTITY, "Generator for GenerationType.IDENTITY not allowed", new Object[0]);
            IdGenerator generator = this.generators.get(new GeneratorId(name, table.getQualifiedName()));
            if (generator == null) {
                generator = this.generators.get(new GeneratorId(name, null));
                ModelException.test(generator != null, "Generator '{}' not found", name);
                IdGenerator derived = generator.derive(table);
                if (derived != generator) {
                    return this.addContextObject(this.generators, ContextModelListener::foundGenerator, new GeneratorId(name, table.getQualifiedName()), derived);
                }
            }
            return generator;
        }
        if (strategy == GenerationType.AUTO) {
            strategy = this.dialect.getAutoGenerationType();
        }
        switch (strategy) {
            case IDENTITY: {
                return this.addContextObject(this.generators, ContextModelListener::foundGenerator, new GeneratorId(column.getUnquotedName(), table.getQualifiedName()), new IdentityValue(this, table, column));
            }
            case TABLE: {
                return this.getDefaultTableGenerator();
            }
            case SEQUENCE: {
                return this.getDefaultSequenceGenerator();
            }
        }
        throw new ModelException("Unknown GenerationType: " + strategy);
    }

    Map<Object, GenerationState> getStates(EntityClass<?> entityClass) {
        Map<Object, GenerationState> entityStates = this.states.get(entityClass.getEntityName());
        if (entityStates == null) {
            entityStates = new HashMap<Object, GenerationState>();
            this.states.put(entityClass.getEntityName(), entityStates);
        }
        return entityStates;
    }

    public void registerGenerators(AnnotatedElement element, GeneratorTable table) {
        GeneratorId key;
        TableGenerator tableGenerator;
        GeneratorId key2;
        IdGenerator existingGenerator;
        SequenceGenerator sequenceGenerator = element.getAnnotation(SequenceGenerator.class);
        if (!(sequenceGenerator == null || (existingGenerator = this.generators.get(key2 = new GeneratorId(sequenceGenerator.name(), null))) instanceof SequenceIdGenerator && ((SequenceIdGenerator)existingGenerator).getSequenceName().equals(sequenceGenerator.sequenceName()))) {
            if (existingGenerator != null) {
                key2 = new GeneratorId(sequenceGenerator.name(), table.getQualifiedName());
            }
            this.addContextObject(this.generators, ContextModelListener::foundGenerator, key2, new SequenceIdGenerator(sequenceGenerator, this));
        }
        if ((tableGenerator = element.getAnnotation(TableGenerator.class)) != null && !this.generators.containsKey(key = new GeneratorId(tableGenerator.name(), null))) {
            this.addContextObject(this.generators, ContextModelListener::foundGenerator, key, new TableIdGenerator(tableGenerator, this));
        }
    }

    public void removeContextModelListener(ContextModelListener listener) {
        this.contextModelListeners.remove(listener);
    }

    public <A extends Annotation> GeneratorTable resolveTable(AssociationOverride override, A annotation, Function<A, String> catalogName, Function<A, String> schemaName, Function<A, String> tableName, String defaultTableName) {
        JoinTable joinTable;
        String table;
        String schema;
        String catalog;
        if (annotation == null) {
            catalog = null;
            schema = null;
            table = defaultTableName;
        } else {
            catalog = catalogName.apply(annotation);
            schema = schemaName.apply(annotation);
            table = (String)StringUtils.defaultIfEmpty((CharSequence)tableName.apply(annotation), (CharSequence)defaultTableName);
        }
        if (override != null && (joinTable = override.joinTable()) != null) {
            catalog = (String)StringUtils.defaultIfEmpty((CharSequence)joinTable.catalog(), (CharSequence)catalog);
            schema = (String)StringUtils.defaultIfEmpty((CharSequence)joinTable.schema(), (CharSequence)catalog);
            table = (String)StringUtils.defaultIfEmpty((CharSequence)joinTable.name(), (CharSequence)table);
        }
        return this.resolveTable(catalog, schema, table);
    }

    public GeneratorTable resolveTable(String catalogName, String schemaName, String tableName) {
        String schema;
        String catalog = (String)StringUtils.defaultIfEmpty((CharSequence)catalogName, null);
        String qualified = this.buildQualifiedName(catalog, schema = (String)StringUtils.defaultIfEmpty((CharSequence)schemaName, null), tableName);
        GeneratorTable table = this.tables.get(qualified);
        if (table != null) {
            return table;
        }
        return this.addContextObject(this.tables, ContextModelListener::foundTable, qualified, new GeneratorTable(this.tables.size(), catalog, schema, tableName, qualified, this));
    }

    public void writeAlignmentStatements(StatementsWriter writer) throws IOException {
        for (IdGenerator generator : this.generators.values()) {
            generator.alignNextValue(writer);
        }
        if (this.defaultSequenceGenerator != null) {
            this.defaultSequenceGenerator.alignNextValue(writer);
        }
        if (this.defaultTableGenerator != null) {
            this.defaultTableGenerator.alignNextValue(writer);
        }
    }

    @Generated
    public GeneratorDialect getDialect() {
        return this.dialect;
    }

    @Generated
    public JpaProvider getProvider() {
        return this.provider;
    }

    @Generated
    public int getMaxUniqueProperties() {
        return this.maxUniqueProperties;
    }

    @Generated
    public UniquePropertyQuality getUniquePropertyQuality() {
        return this.uniquePropertyQuality;
    }

    @Generated
    public boolean isPreferSequenceCurentValue() {
        return this.preferSequenceCurentValue;
    }

    @Generated
    public boolean isWriteRelativeIds() {
        return this.writeRelativeIds;
    }

    @Generated
    public boolean isWriteNullValues() {
        return this.writeNullValues;
    }

    @Generated
    public boolean isQuoteAllIdentifiers() {
        return this.quoteAllIdentifiers;
    }

    @Generated
    public Properties getSettings() {
        return this.settings;
    }

    @Generated
    public Map<Class<?>, EntityClass<?>> getDescriptions() {
        return this.descriptions;
    }

    @Generated
    public Map<String, EntityClass<?>> getDescriptionsByName() {
        return this.descriptionsByName;
    }

    @Generated
    public Map<String, GeneratorTable> getTables() {
        return this.tables;
    }

    @Generated
    public Map<String, Map<Object, GenerationState>> getStates() {
        return this.states;
    }

    @Generated
    public List<ContextModelListener> getContextModelListeners() {
        return this.contextModelListeners;
    }

    @Generated
    public void setDialect(GeneratorDialect dialect) {
        this.dialect = dialect;
    }

    @Generated
    public void setProvider(JpaProvider provider) {
        this.provider = provider;
    }

    @Generated
    public void setMaxUniqueProperties(int maxUniqueProperties) {
        this.maxUniqueProperties = maxUniqueProperties;
    }

    @Generated
    public void setUniquePropertyQuality(UniquePropertyQuality uniquePropertyQuality) {
        this.uniquePropertyQuality = uniquePropertyQuality;
    }

    @Generated
    public void setPreferSequenceCurentValue(boolean preferSequenceCurentValue) {
        this.preferSequenceCurentValue = preferSequenceCurentValue;
    }

    @Generated
    public void setWriteRelativeIds(boolean writeRelativeIds) {
        this.writeRelativeIds = writeRelativeIds;
    }

    @Generated
    public void setWriteNullValues(boolean writeNullValues) {
        this.writeNullValues = writeNullValues;
    }

    @Generated
    public void setQuoteAllIdentifiers(boolean quoteAllIdentifiers) {
        this.quoteAllIdentifiers = quoteAllIdentifiers;
    }

    @Generated
    public void setDefaultSequenceGenerator(SequenceIdGenerator defaultSequenceGenerator) {
        this.defaultSequenceGenerator = defaultSequenceGenerator;
    }

    @Generated
    public void setDefaultTableGenerator(TableIdGenerator defaultTableGenerator) {
        this.defaultTableGenerator = defaultTableGenerator;
    }

    @Generated
    public void setContextModelListeners(List<ContextModelListener> contextModelListeners) {
        this.contextModelListeners = contextModelListeners;
    }

    private static final class GeneratorId {
        private final String id;
        private final String tableName;

        public boolean equals(Object obj) {
            if (obj instanceof GeneratorId) {
                GeneratorId other = (GeneratorId)obj;
                return this.id.equals(other.id) && Objects.equals(this.tableName, other.tableName);
            }
            return false;
        }

        public int hashCode() {
            if (this.tableName == null) {
                return this.id.hashCode();
            }
            return this.id.hashCode() << 2 | this.tableName.hashCode();
        }

        public String toString() {
            if (this.tableName == null) {
                return this.id;
            }
            return this.tableName + '.' + this.id;
        }

        @Generated
        public GeneratorId(String id, String tableName) {
            this.id = id;
            this.tableName = tableName;
        }
    }
}

