/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.fastnate.generator.context.ContextModelListener;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.NamedObject;

public class GeneratorTable
extends NamedObject {
    private final int index;
    private final String catalog;
    private final String schema;
    private final String name;
    private final String qualifiedName;
    private final GeneratorContext context;
    private final Map<String, GeneratorColumn> columns = new LinkedHashMap<String, GeneratorColumn>();

    public String getUnquotedCatalog() {
        return this.unqoteObjectName(this.catalog);
    }

    public String getUnquotedSchema() {
        return this.unqoteObjectName(this.schema);
    }

    public GeneratorColumn resolveColumn(String columnName) {
        return this.resolveColumn(columnName, false);
    }

    public GeneratorColumn resolveColumn(String columnName, boolean autoGenerated) {
        GeneratorColumn column = this.columns.get(columnName);
        if (column == null) {
            column = new GeneratorColumn(this, this.columns.size(), columnName, this.context.adjustIdentifier(columnName), autoGenerated);
            this.columns.put(columnName, column);
            this.context.fireContextObjectAdded(ContextModelListener::foundColumn, column);
        }
        return column;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Generated
    public GeneratorContext getContext() {
        return this.context;
    }

    @Generated
    public Map<String, GeneratorColumn> getColumns() {
        return this.columns;
    }

    @Generated
    public GeneratorTable(int index, String catalog, String schema, String name, String qualifiedName, GeneratorContext context) {
        this.index = index;
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
        this.qualifiedName = qualifiedName;
        this.context = context;
    }
}

