/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import lombok.Generated;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PlainColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public class IdentityValue
extends IdGenerator {
    private final GeneratorContext context;
    private final GeneratorTable table;
    private final GeneratorColumn column;
    private long currentValue;
    private boolean needsAlignment;

    @Override
    public void addNextValue(TableStatement statement, GeneratorColumn tableColumn, Number value) {
    }

    @Override
    public void alignNextValue(StatementsWriter writer) throws IOException {
        if (this.needsAlignment) {
            this.needsAlignment = false;
            if (!this.context.isWriteRelativeIds() && this.context.getDialect().isSettingIdentityAllowed()) {
                this.context.getDialect().adjustNextIdentityValue(writer, this.table, this.column, this.currentValue + 1L);
            }
        }
    }

    @Override
    public long createNextValue() {
        this.needsAlignment = true;
        return ++this.currentValue;
    }

    @Override
    public ColumnExpression getExpression(GeneratorTable entityTable, GeneratorColumn targetColumn, Number targetId, boolean whereExpression) {
        long diff = this.currentValue - targetId.longValue();
        return new PlainColumnExpression("(SELECT max(" + this.column.getQualifiedName() + ")" + (diff == 0L ? "" : " - " + diff) + " FROM " + this.table.getQualifiedName() + ")");
    }

    @Override
    public boolean isPostIncrement() {
        return true;
    }

    @Override
    public void setCurrentValue(long currentValue) {
        this.needsAlignment = false;
        this.currentValue = currentValue;
    }

    @Generated
    public IdentityValue(GeneratorContext context, GeneratorTable table, GeneratorColumn column) {
        this.context = context;
        this.table = table;
        this.column = column;
    }

    @Override
    @Generated
    public long getCurrentValue() {
        return this.currentValue;
    }
}

