/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.persistence.Access;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeOverride;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.generator.context.AccessStyle;
import org.fastnate.generator.context.AnyMapping;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.EntityProperty;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.converter.EntityConverter;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;
import org.fastnate.util.ClassUtil;
import org.hibernate.annotations.ManyToAny;

public abstract class PluralProperty<E, C, T>
extends Property<E, C> {
    private final GeneratorContext context;
    private final GeneratorDialect dialect;
    private List<Property<T, ?>> embeddedProperties;
    private Map<String, Property<T, ?>> embeddedPropertiesByName;
    private List<EntityProperty<T, ?>> requiredEmbeddedProperties;
    private final String mappedId;
    private final GeneratorTable table;
    private GeneratorColumn idColumn;
    private final boolean composition;
    private final String mappedBy;
    private Property<T, ?> inverseProperty;
    private final boolean useTargetTable;
    private final GeneratorColumn valueColumn;
    private final Class<T> valueClass;
    private final Constructor<T> valueConstructor;
    private final boolean entityReference;
    private final EntityClass<T> valueEntityClass;
    private final ValueConverter<T> valueConverter;
    private final AnyMapping<T> anyMapping;

    protected static String buildIdColumn(AttributeAccessor attribute, AssociationOverride override, CollectionTable collectionMetadata, String defaultIdColumn) {
        return PluralProperty.buildIdColumn(attribute, override, collectionMetadata != null ? collectionMetadata.joinColumns() : null, defaultIdColumn);
    }

    private static String buildIdColumn(AttributeAccessor attribute, AssociationOverride override, JoinColumn[] joinColumns, String defaultIdColumn) {
        JoinColumn joinColumn;
        if (override != null) {
            String joinCloumnName = PluralProperty.getJoinColumnName(override.joinColumns());
            if (joinCloumnName != null) {
                return joinCloumnName;
            }
            joinCloumnName = PluralProperty.getJoinColumnName(override.joinTable().joinColumns());
            if (joinCloumnName != null) {
                return joinCloumnName;
            }
        }
        if ((joinColumn = attribute.getAnnotation(JoinColumn.class)) != null && joinColumn.name().length() > 0) {
            return joinColumn.name();
        }
        return StringUtils.defaultString((String)PluralProperty.getJoinColumnName(joinColumns), (String)defaultIdColumn);
    }

    private static String buildIdColumn(AttributeAccessor attribute, AssociationOverride override, JoinTable joinTable, CollectionTable tableMetadata, String defaultIdColumn) {
        return PluralProperty.buildIdColumn(attribute, override, (JoinColumn[])(joinTable != null ? joinTable.joinColumns() : (tableMetadata != null ? tableMetadata.joinColumns() : null)), defaultIdColumn);
    }

    private static GeneratorColumn buildValueColumn(GeneratorTable table, AssociationOverride asscoiationOverride, AttributeOverride attributeOverride, AttributeAccessor attribute, String defaultColumnName) {
        String joinColumnName;
        Column column;
        String joinColumnName2;
        if (asscoiationOverride != null && (joinColumnName2 = PluralProperty.getJoinColumnName(asscoiationOverride.joinTable().inverseJoinColumns())) != null) {
            return table.resolveColumn(joinColumnName2);
        }
        if (attributeOverride != null && (column = attributeOverride.column()) != null && column.name().length() > 0) {
            return table.resolveColumn(column.name());
        }
        JoinTable tableMetadata = attribute.getAnnotation(JoinTable.class);
        if (tableMetadata != null && (joinColumnName = PluralProperty.getJoinColumnName(tableMetadata.inverseJoinColumns())) != null) {
            return table.resolveColumn(joinColumnName);
        }
        Column columnMetadata = attribute.getAnnotation(Column.class);
        if (columnMetadata != null && columnMetadata.name().length() > 0) {
            return table.resolveColumn(columnMetadata.name());
        }
        return table.resolveColumn(defaultColumnName);
    }

    private static String findMappedId(AttributeAccessor attribute) {
        MapsId mapsId = attribute.getAnnotation(MapsId.class);
        return mapsId == null || mapsId.value().length() == 0 ? null : mapsId.value();
    }

    private static <T> Constructor<T> findValueConstructor(Class<T> valueClass) {
        try {
            Constructor<T> constructor = valueClass.getConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String getJoinColumnName(JoinColumn[] joinColumns) {
        JoinColumn joinColumn;
        if (joinColumns != null && joinColumns.length > 0 && (joinColumn = joinColumns[0]).name().length() > 0) {
            return joinColumn.name();
        }
        return null;
    }

    protected static <T> Class<T> getPropertyArgument(AttributeAccessor attribute, Class<T> explicitClass, int argumentIndex) {
        if (explicitClass != Void.TYPE) {
            return explicitClass;
        }
        ModelException.test(attribute.getGenericType() instanceof ParameterizedType, "{} is not of generic type and has no defined entity class", attribute);
        ParameterizedType type = (ParameterizedType)attribute.getGenericType();
        Type[] parameterArgTypes = type.getActualTypeArguments();
        ModelException.test(argumentIndex < parameterArgTypes.length, "{} has illegal generic type signature", attribute);
        return ClassUtil.getActualTypeBinding(attribute.getImplementationClass(), attribute.getDeclaringClass(), parameterArgTypes[argumentIndex]);
    }

    protected static boolean hasPluralAnnotation(AttributeAccessor attribute) {
        return attribute.isAnnotationPresent(OneToMany.class) || attribute.isAnnotationPresent(ManyToMany.class) || attribute.isAnnotationPresent(ElementCollection.class) || attribute.isAnnotationPresent(ManyToAny.class);
    }

    private static String resolveAnnotationAttribute(AssociationOverride override, JoinTable joinTable, CollectionTable collectionTable, Function<JoinTable, String> joinTableAttribute, Function<CollectionTable, String> collectionTableAttribute, String defaultAttribute) {
        String value;
        String value2;
        JoinTable joinTableOverride;
        if (override != null && (joinTableOverride = override.joinTable()) != null && (value2 = joinTableAttribute.apply(joinTableOverride)).length() > 0) {
            return value2;
        }
        if (joinTable != null && (value = joinTableAttribute.apply(joinTable)).length() > 0) {
            return value;
        }
        if (collectionTable != null && (value = collectionTableAttribute.apply(collectionTable)).length() > 0) {
            return value;
        }
        return defaultAttribute;
    }

    private static GeneratorTable resolveTable(GeneratorContext context, AssociationOverride override, JoinTable joinTable, CollectionTable collectionTable, GeneratorTable sourceEntityTable, String targetEntityTable) {
        return context.resolveTable(PluralProperty.resolveAnnotationAttribute(override, joinTable, collectionTable, JoinTable::catalog, CollectionTable::catalog, sourceEntityTable.getCatalog()), PluralProperty.resolveAnnotationAttribute(override, joinTable, collectionTable, JoinTable::schema, CollectionTable::schema, sourceEntityTable.getSchema()), PluralProperty.resolveAnnotationAttribute(override, joinTable, collectionTable, JoinTable::name, CollectionTable::name, sourceEntityTable.getUnquotedName() + '_' + targetEntityTable));
    }

    public PluralProperty(EntityClass<?> sourceClass, AttributeAccessor attribute, AssociationOverride associationOverride, AttributeOverride attributeOverride, int valueClassParamIndex) {
        super(attribute);
        this.context = sourceClass.getContext();
        this.dialect = this.context.getDialect();
        this.mappedId = PluralProperty.findMappedId(attribute);
        CollectionTable collectionTable = attribute.getAnnotation(CollectionTable.class);
        ElementCollection values = attribute.getAnnotation(ElementCollection.class);
        boolean bl = this.entityReference = values == null;
        if (values == null) {
            MappingInformation mapping = new MappingInformation(attribute, associationOverride, valueClassParamIndex);
            this.mappedBy = mapping.getMappedBy();
            this.useTargetTable = mapping.isUseTargetTable();
            this.composition = mapping.isComposition();
            this.valueClass = mapping.getValueClass();
            this.valueEntityClass = sourceClass.getContext().getDescription(this.valueClass);
            ModelException.test(this.valueEntityClass != null || mapping.getAnyColumn() != null, "{} has no entity as value", attribute);
            this.valueConverter = null;
            if (this.mappedBy != null) {
                this.table = this.valueEntityClass.getTable();
                this.initializeInverseProperty();
                this.valueColumn = PluralProperty.buildValueColumn(this.table, null, null, attribute, this.valueEntityClass.getIdColumn(attribute).getName());
                this.anyMapping = null;
            } else if (this.useTargetTable) {
                this.table = this.valueEntityClass.getTable();
                this.idColumn = this.table.resolveColumn(PluralProperty.buildIdColumn(attribute, associationOverride, null, null, attribute.getName() + '_' + sourceClass.getIdColumn(attribute).getUnquotedName()));
                this.valueColumn = PluralProperty.buildValueColumn(this.table, null, null, attribute, this.valueEntityClass.getIdColumn(attribute).getName());
                this.anyMapping = null;
            } else {
                JoinTable joinTable = attribute.getAnnotation(JoinTable.class);
                this.table = PluralProperty.resolveTable(this.context, associationOverride, joinTable, collectionTable, sourceClass.getTable(), this.valueEntityClass == null ? "table" : this.valueEntityClass.getTable().getUnquotedName());
                this.initializeIdColumnForMappingTable(sourceClass, attribute, associationOverride, joinTable, collectionTable);
                this.valueColumn = PluralProperty.buildValueColumn(this.table, associationOverride, null, attribute, attribute.getName() + '_' + (this.valueEntityClass == null ? "id" : this.valueEntityClass.getIdColumn(attribute).getUnquotedName()));
                this.anyMapping = mapping.buildAnyMapping(this.context, this.table);
            }
        } else {
            this.mappedBy = null;
            this.useTargetTable = false;
            this.anyMapping = null;
            this.composition = true;
            this.table = this.context.resolveTable(associationOverride, collectionTable, CollectionTable::catalog, CollectionTable::schema, CollectionTable::name, sourceClass.getEntityName() + '_' + attribute.getName());
            this.idColumn = this.table.resolveColumn(PluralProperty.buildIdColumn(attribute, associationOverride, collectionTable, sourceClass.getEntityName() + '_' + sourceClass.getIdColumn(attribute).getUnquotedName()));
            this.valueClass = PluralProperty.getPropertyArgument(attribute, values.targetClass(), valueClassParamIndex);
            this.valueEntityClass = null;
            if (this.valueClass.isAnnotationPresent(Embeddable.class)) {
                this.buildEmbeddedProperties(sourceClass, this.valueClass);
                this.valueConverter = null;
                this.valueColumn = null;
            } else {
                this.valueConverter = this.context.getProvider().createConverter(attribute, this.valueClass, false);
                this.valueColumn = PluralProperty.buildValueColumn(this.table, null, attributeOverride, attribute, attribute.getName());
            }
        }
        this.valueConstructor = PluralProperty.findValueConstructor(this.valueClass);
    }

    @Override
    public void addInsertExpression(TableStatement statement, E entity) {
    }

    protected void buildEmbeddedProperties(EntityClass<?> sourceClass, Class<?> targetType) {
        if (targetType.isAnnotationPresent(Embeddable.class)) {
            this.embeddedProperties = new ArrayList();
            this.embeddedPropertiesByName = new HashMap();
            this.requiredEmbeddedProperties = new ArrayList();
            Access accessType = targetType.getAnnotation(Access.class);
            AccessStyle accessStyle = accessType != null ? AccessStyle.getStyle(accessType.value()) : this.getAttribute().getAccessStyle();
            String prefix = this.getAttribute().getName() + '.';
            Map<String, AttributeOverride> attributeOverrides = EntityClass.getAttributeOverrides(sourceClass.getAttributeOverrides(), prefix, this.getAttribute().getElement());
            Map<String, AssociationOverride> accociationOverrides = EntityClass.getAccociationOverrides(sourceClass.getAssociationOverrides(), prefix, this.getAttribute().getElement());
            for (AttributeAccessor attribute : accessStyle.getDeclaredAttributes(targetType, this.getAttribute().getImplementationClass())) {
                if (!attribute.isPersistent()) continue;
                Property property = sourceClass.buildProperty(this.table, attribute, attributeOverrides, accociationOverrides);
                this.embeddedProperties.add(property);
                this.embeddedPropertiesByName.put(property.getName(), property);
                if (!(property instanceof EntityProperty) || !property.isRequired()) continue;
                this.requiredEmbeddedProperties.add((EntityProperty)property);
            }
        }
    }

    protected void createDirectValueStatement(StatementsWriter writer, E entity, ColumnExpression sourceId, ColumnExpression key, T value) throws IOException {
        ColumnExpression target = this.createValueExpression(entity, sourceId, value, key);
        if (target != null) {
            GeneratorColumn keyColumn;
            TableStatement stmt;
            if (this.useTargetTable) {
                if (value == null) {
                    return;
                }
                stmt = writer.createUpdateStatement(this.dialect, this.table, this.valueColumn, target);
                if (this.mappedBy == null) {
                    stmt.setColumnValue(this.idColumn, sourceId);
                }
            } else {
                stmt = writer.createInsertStatement(this.dialect, this.table);
                stmt.setColumnValue(this.idColumn, sourceId);
                stmt.setColumnValue(this.valueColumn, target);
                if (this.anyMapping != null) {
                    this.anyMapping.setColumnValue(stmt, value);
                }
            }
            if ((keyColumn = this.getKeyColumn()) != null) {
                stmt.setColumnValue(keyColumn, key);
            }
            writer.writeStatement(stmt);
        }
    }

    private void createEmbeddedValueStatement(StatementsWriter writer, E entity, ColumnExpression sourceId, ColumnExpression key, T value) throws IOException {
        for (EntityProperty<T, ?> requiredProperty : this.requiredEmbeddedProperties) {
            EntityClass<Class<?>> targetDescription;
            Property<Class<?>, ?> idProperty;
            Object referencedEntity = requiredProperty.getValue(value);
            if (referencedEntity == null || (idProperty = (targetDescription = this.context.getDescription(referencedEntity.getClass())).getIdProperty()).getValue((Class<?>)referencedEntity) != null) continue;
            targetDescription.markPendingUpdates((Class<?>)referencedEntity, entity, this, key, value);
            return;
        }
        TableStatement stmt = writer.createInsertStatement(this.dialect, this.getTable());
        stmt.setColumnValue(this.getIdColumn(), sourceId);
        if (this.getKeyColumn() != null) {
            stmt.setColumnValue(this.getKeyColumn(), key);
        }
        for (Property<T, ?> property : this.embeddedProperties) {
            property.addInsertExpression(stmt, value);
        }
        writer.writeStatement(stmt);
    }

    protected ColumnExpression createValueExpression(E entity, ColumnExpression sourceId, T value, ColumnExpression key) {
        if (value == null) {
            return PrimitiveColumnExpression.NULL;
        }
        if (this.valueConverter != null) {
            return this.valueConverter.getExpression(value, this.getContext());
        }
        EntityClass<T> entityClass = this.valueEntityClass == null ? this.context.getDescription(value) : this.valueEntityClass;
        ColumnExpression target = entityClass.getEntityReference(value, this.mappedId, this.useTargetTable);
        if (target == null) {
            entityClass.markPendingUpdates(value, entity, this, key, value);
        }
        return target;
    }

    protected void createValueStatement(StatementsWriter writer, E entity, ColumnExpression sourceId, ColumnExpression key, T value) throws IOException {
        if (this.isEmbedded()) {
            this.createEmbeddedValueStatement(writer, entity, sourceId, key, value);
        } else {
            this.createDirectValueStatement(writer, entity, sourceId, key, value);
        }
    }

    @Override
    public void generatePendingStatements(StatementsWriter writer, E entity, Object writtenEntity, Object ... arguments) throws IOException {
        ColumnExpression sourceId = EntityConverter.getEntityReference(entity, this.mappedId, this.getContext(), false);
        this.createValueStatement(writer, entity, sourceId, (ColumnExpression)arguments[0], arguments[1]);
    }

    protected abstract GeneratorColumn getKeyColumn();

    private void initializeIdColumnForMappingTable(EntityClass<?> sourceClass, AttributeAccessor attribute, AssociationOverride override, JoinTable joinTable, CollectionTable collectionTable) {
        String idColumnName = PluralProperty.buildIdColumn(attribute, override, joinTable, collectionTable, null);
        if (idColumnName != null) {
            this.idColumn = this.table.resolveColumn(idColumnName);
        } else {
            this.valueEntityClass.onPropertiesAvailable(entityClass -> {
                String entityName = entityClass.getAllProperties().stream().filter(p -> {
                    if (p instanceof PluralProperty) {
                        PluralProperty other = (PluralProperty)p;
                        return other.getValueEntityClass() == sourceClass && this.getName().equals(other.getMappedBy());
                    }
                    return false;
                }).map(Property::getName).findFirst().orElseGet(sourceClass::getEntityName);
                this.idColumn = this.table.resolveColumn(entityName + '_' + sourceClass.getIdColumn(this.getAttribute()).getUnquotedName());
            });
        }
    }

    private void initializeInverseProperty() {
        this.valueEntityClass.onPropertiesAvailable(entityClass -> {
            this.inverseProperty = entityClass.getProperties().get(this.mappedBy);
            if (this.inverseProperty instanceof EntityProperty) {
                EntityProperty entityProperty = (EntityProperty)this.inverseProperty;
                this.idColumn = entityProperty.getColumn();
                entityProperty.setInverseProperty(this);
            } else if (this.inverseProperty instanceof PluralProperty) {
                PluralProperty pluralProperty = (PluralProperty)this.inverseProperty;
                this.idColumn = pluralProperty.getValueColumn();
                pluralProperty.inverseProperty = this;
            } else {
                throw new ModelException("Unsupported \"mapped by\" property for " + this.getAttribute());
            }
        });
    }

    public boolean isEmbedded() {
        return this.embeddedProperties != null;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isTableColumn() {
        return false;
    }

    public T newElement() {
        if (this.valueConstructor == null) {
            throw new UnsupportedOperationException("The element class has no parameter-less constructor");
        }
        try {
            return this.valueConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Could not create new element", e);
        }
    }

    @Generated
    public GeneratorContext getContext() {
        return this.context;
    }

    @Generated
    public GeneratorDialect getDialect() {
        return this.dialect;
    }

    @Generated
    public List<Property<T, ?>> getEmbeddedProperties() {
        return this.embeddedProperties;
    }

    @Generated
    public Map<String, Property<T, ?>> getEmbeddedPropertiesByName() {
        return this.embeddedPropertiesByName;
    }

    @Generated
    public List<EntityProperty<T, ?>> getRequiredEmbeddedProperties() {
        return this.requiredEmbeddedProperties;
    }

    @Generated
    public String getMappedId() {
        return this.mappedId;
    }

    @Generated
    public GeneratorTable getTable() {
        return this.table;
    }

    @Generated
    public GeneratorColumn getIdColumn() {
        return this.idColumn;
    }

    @Generated
    public boolean isComposition() {
        return this.composition;
    }

    @Generated
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Generated
    public Property<T, ?> getInverseProperty() {
        return this.inverseProperty;
    }

    @Generated
    public boolean isUseTargetTable() {
        return this.useTargetTable;
    }

    @Generated
    public GeneratorColumn getValueColumn() {
        return this.valueColumn;
    }

    @Generated
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Generated
    public Constructor<T> getValueConstructor() {
        return this.valueConstructor;
    }

    @Generated
    public boolean isEntityReference() {
        return this.entityReference;
    }

    @Generated
    public EntityClass<T> getValueEntityClass() {
        return this.valueEntityClass;
    }

    @Generated
    public ValueConverter<T> getValueConverter() {
        return this.valueConverter;
    }

    @Generated
    public AnyMapping<T> getAnyMapping() {
        return this.anyMapping;
    }

    private static class MappingInformation {
        private final AttributeAccessor attribute;
        private final Class<?> valueClass;
        private final String mappedBy;
        private final boolean useTargetTable;
        private final Column anyColumn;
        private final String anyDefName;
        private final boolean composition;

        private static boolean useTargetTable(AttributeAccessor attribute, AssociationOverride override) {
            JoinColumn joinColumn = override != null && override.joinColumns().length > 0 ? override.joinColumns()[0] : attribute.getAnnotation(JoinColumn.class);
            JoinTable joinTable = override != null && override.joinTable() != null ? override.joinTable() : attribute.getAnnotation(JoinTable.class);
            return joinColumn != null && joinTable == null;
        }

        MappingInformation(AttributeAccessor attribute, AssociationOverride override, int valueArgumentIndex) {
            this.attribute = attribute;
            OneToMany oneToMany = attribute.getAnnotation(OneToMany.class);
            if (oneToMany != null) {
                this.valueClass = PluralProperty.getPropertyArgument(attribute, oneToMany.targetEntity(), valueArgumentIndex);
                this.mappedBy = oneToMany.mappedBy().length() == 0 ? null : oneToMany.mappedBy();
                this.useTargetTable = this.mappedBy != null || MappingInformation.useTargetTable(attribute, override);
                this.anyColumn = null;
                this.anyDefName = null;
                this.composition = Property.isComposition(oneToMany.cascade());
            } else {
                ManyToMany manyToMany = attribute.getAnnotation(ManyToMany.class);
                if (manyToMany != null) {
                    this.valueClass = PluralProperty.getPropertyArgument(attribute, manyToMany.targetEntity(), valueArgumentIndex);
                    this.mappedBy = manyToMany.mappedBy().length() == 0 ? null : manyToMany.mappedBy();
                    this.useTargetTable = this.mappedBy != null;
                    this.anyColumn = null;
                    this.anyDefName = null;
                    this.composition = Property.isComposition(manyToMany.cascade());
                } else {
                    ManyToAny manyToAny = attribute.getAnnotation(ManyToAny.class);
                    ModelException.mustExist(manyToAny, "{} declares none of OneToMany, ManyToMany, ElementCollection, or AnyToMany", attribute);
                    this.valueClass = PluralProperty.getPropertyArgument(attribute, Void.TYPE, valueArgumentIndex);
                    this.mappedBy = null;
                    this.useTargetTable = false;
                    this.anyColumn = manyToAny.metaColumn();
                    this.anyDefName = manyToAny.metaDef();
                    this.composition = false;
                }
            }
        }

        <T> AnyMapping<T> buildAnyMapping(GeneratorContext context, GeneratorTable containerTable) {
            if (this.anyColumn == null) {
                return null;
            }
            return new AnyMapping(context, this.attribute, containerTable, this.anyColumn, this.anyDefName);
        }

        @Generated
        public AttributeAccessor getAttribute() {
            return this.attribute;
        }

        @Generated
        public Class<?> getValueClass() {
            return this.valueClass;
        }

        @Generated
        public String getMappedBy() {
            return this.mappedBy;
        }

        @Generated
        public boolean isUseTargetTable() {
            return this.useTargetTable;
        }

        @Generated
        public Column getAnyColumn() {
            return this.anyColumn;
        }

        @Generated
        public String getAnyDefName() {
            return this.anyDefName;
        }

        @Generated
        public boolean isComposition() {
            return this.composition;
        }
    }
}

