/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import javax.persistence.TableGenerator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.provider.JpaProvider;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PlainColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public class TableIdGenerator
extends IdGenerator {
    private final GeneratorDialect dialect;
    private final boolean relativeIds;
    private final GeneratorTable generatorTable;
    private final GeneratorColumn pkColumn;
    private final ColumnExpression pkColumnValue;
    private final GeneratorColumn valueColumn;
    private final int allocationSize;
    private long initialValue;
    private long nextValue;
    private long maxAllocatedValue;

    public TableIdGenerator(TableGenerator generator, GeneratorContext context) {
        this.dialect = context.getDialect();
        this.relativeIds = context.isWriteRelativeIds();
        this.allocationSize = generator.allocationSize();
        ModelException.test(this.allocationSize > 0, "Only allocation sizes greater 0 are allowed, found {}", this.allocationSize);
        this.nextValue = this.initialValue = (long)generator.initialValue();
        this.maxAllocatedValue = this.initialValue - 1L;
        JpaProvider provider = context.getProvider();
        this.generatorTable = context.resolveTable(generator.catalog(), generator.schema(), (String)StringUtils.defaultIfEmpty((CharSequence)generator.table(), (CharSequence)provider.getDefaultGeneratorTable()));
        this.valueColumn = this.generatorTable.resolveColumn((String)StringUtils.defaultIfEmpty((CharSequence)generator.valueColumnName(), (CharSequence)provider.getDefaultGeneratorTableValueColumnName()));
        this.pkColumn = this.generatorTable.resolveColumn((String)StringUtils.defaultIfEmpty((CharSequence)generator.pkColumnName(), (CharSequence)provider.getDefaultGeneratorTablePkColumnName()));
        String value = (String)StringUtils.defaultIfEmpty((CharSequence)generator.pkColumnValue(), (CharSequence)provider.getDefaultGeneratorTablePkColumnValue());
        this.pkColumnValue = StringUtils.isEmpty((CharSequence)value) ? null : PrimitiveColumnExpression.create(value, this.dialect);
    }

    @Override
    public void addNextValue(TableStatement statement, GeneratorColumn column, Number value) {
        statement.setColumnValue(column, new PlainColumnExpression("(SELECT " + this.valueColumn + " - " + (this.getValueColumnValue() - value.longValue()) + " FROM " + this.generatorTable + " WHERE " + this.pkColumn + " = " + this.pkColumnValue + ')'));
    }

    @Override
    public void alignNextValue(StatementsWriter writer) throws IOException {
        if (this.relativeIds) {
            if (this.maxAllocatedValue >= this.nextValue) {
                TableStatement statement = writer.createUpdateStatement(this.dialect, this.generatorTable, this.pkColumn, this.pkColumnValue);
                statement.setColumnValue(this.valueColumn, new PlainColumnExpression(this.valueColumn + " - " + (this.maxAllocatedValue - (this.nextValue - 1L))));
                this.maxAllocatedValue = this.nextValue - 1L;
                writer.writeStatement(statement);
            }
        } else if (this.maxAllocatedValue < this.initialValue) {
            if (this.nextValue > this.initialValue) {
                this.maxAllocatedValue = this.nextValue;
                TableStatement statement = writer.createInsertStatement(this.dialect, this.generatorTable);
                statement.setColumnValue(this.pkColumn, this.pkColumnValue);
                statement.setColumnValue(this.valueColumn, PrimitiveColumnExpression.create(this.maxAllocatedValue + (long)this.allocationSize - 1L, this.dialect));
                writer.writeStatement(statement);
            }
        } else if (this.maxAllocatedValue >= this.nextValue) {
            TableStatement statement = writer.createUpdateStatement(this.dialect, this.generatorTable, this.pkColumn, this.pkColumnValue);
            this.maxAllocatedValue = this.nextValue;
            statement.setColumnValue(this.valueColumn, PrimitiveColumnExpression.create(this.maxAllocatedValue + (long)this.allocationSize - 1L, this.dialect));
            writer.writeStatement(statement);
        }
    }

    @Override
    public long createNextValue() {
        return this.nextValue++;
    }

    @Override
    public void createPreInsertStatements(StatementsWriter writer) throws IOException {
        if (this.maxAllocatedValue < this.nextValue) {
            boolean firstUpdate = this.maxAllocatedValue < this.initialValue;
            this.maxAllocatedValue += (long)this.allocationSize;
            if (this.relativeIds) {
                if (firstUpdate) {
                    writer.writePlainStatement(this.dialect, "INSERT INTO " + this.generatorTable + " (" + this.pkColumn + ", " + this.valueColumn + ") SELECT " + this.pkColumnValue + ", " + this.maxAllocatedValue + ' ' + this.dialect.getOptionalTable() + " WHERE NOT EXISTS (SELECT * FROM " + this.generatorTable + " WHERE " + this.pkColumn + " = " + this.pkColumnValue + ')');
                }
                TableStatement statement = writer.createUpdateStatement(this.dialect, this.generatorTable, this.pkColumn, this.pkColumnValue);
                statement.setColumnValue(this.valueColumn, new PlainColumnExpression(this.valueColumn + " + " + this.allocationSize));
                writer.writeStatement(statement);
            } else {
                TableStatement statement;
                if (firstUpdate) {
                    statement = writer.createInsertStatement(this.dialect, this.generatorTable);
                    statement.setColumnValue(this.pkColumn, this.pkColumnValue);
                } else {
                    statement = writer.createUpdateStatement(this.dialect, this.generatorTable, this.pkColumn, this.pkColumnValue);
                }
                statement.setColumnValue(this.valueColumn, PrimitiveColumnExpression.create(this.maxAllocatedValue + (long)this.allocationSize, this.dialect));
                writer.writeStatement(statement);
            }
        }
    }

    @Override
    public IdGenerator derive(GeneratorTable currentTable) {
        if (this.pkColumnValue == null) {
            return new TableIdGenerator(this.dialect, this.relativeIds, this.generatorTable, this.pkColumn, PrimitiveColumnExpression.create(currentTable.getUnquotedName(), this.dialect), this.valueColumn, this.allocationSize, this.initialValue, this.nextValue, this.maxAllocatedValue);
        }
        return this;
    }

    @Override
    public long getCurrentValue() {
        return this.nextValue - 1L;
    }

    @Override
    public ColumnExpression getExpression(GeneratorTable table, GeneratorColumn column, Number targetId, boolean whereExpression) {
        long diff = this.getValueColumnValue() - targetId.longValue();
        return new PlainColumnExpression("(SELECT " + this.valueColumn.getQualifiedName() + (diff == 0L ? "" : " - " + diff) + " FROM " + this.generatorTable.getQualifiedName() + " WHERE " + this.pkColumn.getQualifiedName() + " = " + this.pkColumnValue + ')');
    }

    private long getValueColumnValue() {
        return this.maxAllocatedValue + (long)this.allocationSize;
    }

    @Override
    public boolean isPostIncrement() {
        return false;
    }

    @Override
    public void setCurrentValue(long currentValue) {
        this.nextValue = currentValue + 1L;
        this.maxAllocatedValue = currentValue;
    }

    @Generated
    public GeneratorDialect getDialect() {
        return this.dialect;
    }

    @Generated
    public boolean isRelativeIds() {
        return this.relativeIds;
    }

    @Generated
    public GeneratorTable getGeneratorTable() {
        return this.generatorTable;
    }

    @Generated
    public GeneratorColumn getPkColumn() {
        return this.pkColumn;
    }

    @Generated
    public ColumnExpression getPkColumnValue() {
        return this.pkColumnValue;
    }

    @Generated
    public GeneratorColumn getValueColumn() {
        return this.valueColumn;
    }

    @Generated
    public int getAllocationSize() {
        return this.allocationSize;
    }

    @Generated
    public long getInitialValue() {
        return this.initialValue;
    }

    @Generated
    public long getNextValue() {
        return this.nextValue;
    }

    @Generated
    public long getMaxAllocatedValue() {
        return this.maxAllocatedValue;
    }

    @Generated
    private TableIdGenerator(GeneratorDialect dialect, boolean relativeIds, GeneratorTable generatorTable, GeneratorColumn pkColumn, ColumnExpression pkColumnValue, GeneratorColumn valueColumn, int allocationSize, long initialValue, long nextValue, long maxAllocatedValue) {
        this.dialect = dialect;
        this.relativeIds = relativeIds;
        this.generatorTable = generatorTable;
        this.pkColumn = pkColumn;
        this.pkColumnValue = pkColumnValue;
        this.valueColumn = valueColumn;
        this.allocationSize = allocationSize;
        this.initialValue = initialValue;
        this.nextValue = nextValue;
        this.maxAllocatedValue = maxAllocatedValue;
    }
}

