/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.persistence.MapKeyTemporal;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;
import org.fastnate.generator.RelativeDate;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public abstract class AbstractDateConverter<T>
implements ValueConverter<T> {
    private static final Map<Pattern, DateFormat> DEFAULT_FORMATS = new LinkedHashMap<Pattern, DateFormat>();
    private final TemporalType type;

    public AbstractDateConverter(AttributeAccessor attribute, boolean mapKey) {
        TemporalType temporalType = TemporalType.TIMESTAMP;
        if (mapKey) {
            MapKeyTemporal temporal = attribute.getAnnotation(MapKeyTemporal.class);
            if (temporal != null) {
                temporalType = temporal.value();
            }
        } else {
            Temporal temporal = attribute.getAnnotation(Temporal.class);
            if (temporal != null) {
                temporalType = temporal.value();
            }
        }
        this.type = temporalType;
    }

    @Override
    public ColumnExpression getExpression(Date value, GeneratorContext context) {
        return new PrimitiveColumnExpression<Date>(value, context.getDialect().convertToDatabaseDate(value, this.type), v -> context.getDialect().convertTemporalValue(value, this.type));
    }

    @Override
    public ColumnExpression getExpression(String defaultValue, GeneratorContext context) {
        if ("CURRENT_TIMESTAMP".equals(defaultValue)) {
            return this.getExpression(RelativeDate.NOW, context);
        }
        if ("CURRENT_DATE".equals(defaultValue)) {
            return this.getExpression(RelativeDate.TODAY, context);
        }
        for (Map.Entry<Pattern, DateFormat> format : DEFAULT_FORMATS.entrySet()) {
            if (!format.getKey().matcher(defaultValue).matches()) continue;
            try {
                return this.getExpression(format.getValue().parse(defaultValue), context);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Can't parse " + defaultValue + " as date", e);
            }
        }
        return new PrimitiveColumnExpression<String>(defaultValue, Function.identity());
    }

    @Generated
    public AbstractDateConverter(TemporalType type) {
        this.type = type;
    }

    static {
        DEFAULT_FORMATS.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}"), new SimpleDateFormat("yyyy-MM-dd"));
        DEFAULT_FORMATS.put(Pattern.compile("\\d{2}:\\d{2}:\\d{2}"), new SimpleDateFormat("HH:mm:ss"));
        DEFAULT_FORMATS.put(Pattern.compile("\\d{2}:\\d{2}:\\d{2}\\.\\d{3}"), new SimpleDateFormat("HH:mm:ss.S"));
        DEFAULT_FORMATS.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        DEFAULT_FORMATS.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+-]\\d{2}:\\d{2}"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX"));
        DEFAULT_FORMATS.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+-]\\d{2}\\d{2}?"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzz"));
        DEFAULT_FORMATS.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
        DEFAULT_FORMATS.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{2}:\\d{2}"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
        DEFAULT_FORMATS.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{2}\\d{2}?"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSzzz"));
    }
}

