/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.Function;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public class TemporalConverter<T extends Temporal>
implements ValueConverter<T> {
    private Method parse;
    private Function<T, String> toString;

    public TemporalConverter(Class<?> type) {
        try {
            Method method = type.getMethod("parse", CharSequence.class);
            if (Modifier.isAbstract(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getReturnType() != type) {
                throw new ModelException(type + " is not supported by the TemporalConverter!");
            }
            this.parse = method;
            this.toString = type == ZonedDateTime.class ? t -> t.toLocalDateTime().toString() + t.getOffset().toString() : Object::toString;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ModelException(type + " is not supported by the TemporalConverter!", e);
        }
    }

    @Override
    public ColumnExpression getExpression(String defaultValue, GeneratorContext context) {
        try {
            return this.getExpression((T)((Temporal)this.parse.invoke(null, defaultValue)), context);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not convert " + defaultValue + " to a temporal value", e);
        }
    }

    @Override
    public ColumnExpression getExpression(T value, GeneratorContext context) {
        GeneratorDialect dialect = context.getDialect();
        return new PrimitiveColumnExpression<Temporal>((Temporal)value, t -> dialect.quoteString(this.toString.apply((Temporal)t)));
    }
}

