/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.GenerationType;
import javax.persistence.TemporalType;
import lombok.Generated;
import org.fastnate.generator.RelativeDate;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.statements.StatementsWriter;

public abstract class GeneratorDialect {
    @Deprecated
    public static final Date NOW = RelativeDate.NOW;
    private final char[] letter = "0123456789ABCDEF".toCharArray();

    private static void finishPart(StringBuilder result, String value, int start, int end, boolean isOpen, boolean close, String concatOperator) {
        if (start < end) {
            if (!isOpen) {
                if (start > 0) {
                    result.append(concatOperator);
                }
                result.append('\'');
            }
            result.append(value, start, end);
            if (close) {
                result.append('\'');
            }
        } else if (isOpen && close) {
            result.append('\'');
        } else if (!isOpen && !close) {
            if (start > 0) {
                result.append(concatOperator);
            }
            result.append('\'');
        }
    }

    protected void addQuotedCharacter(StringBuilder result, char c) {
        result.append("CHR(").append((byte)c).append(')');
    }

    public void adjustNextIdentityValue(StatementsWriter writer, GeneratorTable table, GeneratorColumn column, long nextValue) throws IOException {
    }

    public void adjustNextSequenceValue(StatementsWriter writer, String sequenceName, long currentSequenceValue, long nextSequenceValue, int incrementSize) throws IOException {
        if (this.isEmulatingSequences()) {
            writer.writePlainStatement(this, "UPDATE " + sequenceName + " SET next_val = " + nextSequenceValue);
        } else {
            writer.writePlainStatement(this, "ALTER SEQUENCE " + sequenceName + " RESTART WITH " + nextSequenceValue);
        }
    }

    public String buildCurrentSequenceValue(String sequence, int incrementSize, boolean firstCall) {
        if (this.isEmulatingSequences()) {
            return "(SELECT max(next_val) - " + incrementSize + " FROM " + sequence + ")";
        }
        return "currval('" + sequence + "')";
    }

    public String buildNextSequenceValue(String sequence, int incrementSize) {
        if (this.isEmulatingSequences()) {
            return "UPDATE " + sequence + " SET next_val = next_val + " + incrementSize;
        }
        return "nextval('" + sequence + "')";
    }

    public String convertBooleanValue(boolean value) {
        return value ? "1" : "0";
    }

    public String convertNumberValue(Number value) {
        return String.valueOf(value);
    }

    protected String convertTemporalValue(Date sqlDate) {
        return '\'' + sqlDate.toString() + '\'';
    }

    public String convertTemporalValue(Date value, TemporalType type) {
        if (RelativeDate.NOW.equals(value)) {
            return "CURRENT_TIMESTAMP";
        }
        if (RelativeDate.TODAY.equals(value)) {
            return "CURRENT_DATE";
        }
        if (value instanceof RelativeDate) {
            RelativeDate relativeDate = (RelativeDate)value;
            long difference = relativeDate.getDifference();
            RelativeDate.Precision precision = relativeDate.getPrecision();
            return this.createAddDateExpression(this.convertTemporalValue(((RelativeDate)value).getReferenceDate(), type), difference / precision.getMillis(), precision.getUnit());
        }
        return this.convertTemporalValue(this.convertToDatabaseDate(value, type));
    }

    public Date convertToDatabaseDate(Date value, TemporalType type) {
        Date actualTime = value;
        if (value instanceof RelativeDate) {
            RelativeDate relativeDate = (RelativeDate)value;
            if (RelativeDate.NOW == relativeDate.getReferenceDate()) {
                actualTime = new Date(System.currentTimeMillis() + relativeDate.getDifference());
            }
        } else if (RelativeDate.NOW.equals(value)) {
            actualTime = new Date(System.currentTimeMillis());
        }
        switch (type) {
            case DATE: {
                return actualTime instanceof java.sql.Date ? (java.sql.Date)actualTime : new java.sql.Date(actualTime.getTime());
            }
            case TIME: {
                return actualTime instanceof Time ? (Time)actualTime : new Time(actualTime.getTime());
            }
        }
        return actualTime instanceof Timestamp ? (Timestamp)actualTime : new Timestamp(actualTime.getTime());
    }

    protected String createAddDateExpression(String referenceDate, long value, String unit) {
        return "DATEADD(" + unit + ", " + value + ", " + referenceDate + ')';
    }

    public String createBlobExpression(byte[] blob) {
        throw new IllegalArgumentException("Blobs are not supported by " + this.getClass().getSimpleName());
    }

    protected String createHexBlobExpression(String prefix, byte[] blob, String suffix) {
        int start = prefix.length();
        int suffixStart = start + blob.length * 2;
        char[] result = new char[suffixStart + suffix.length()];
        prefix.getChars(0, start, result, 0);
        for (int i = 0; i < blob.length; ++i) {
            int v = blob[i] & 0xFF;
            result[i * 2 + start] = this.letter[v >>> 4];
            result[i * 2 + start + 1] = this.letter[v & 0xF];
        }
        suffix.getChars(0, suffix.length(), result, suffixStart);
        return new String(result);
    }

    public GenerationType getAutoGenerationType() {
        return this.isSequenceSupported() ? GenerationType.SEQUENCE : (this.isIdentitySupported() ? GenerationType.IDENTITY : GenerationType.TABLE);
    }

    public String getConcatOperator() {
        return " || ";
    }

    public Object getEmptyValuesExpression() {
        return "DEFAULT VALUES";
    }

    public String getOptionalTable() {
        return "";
    }

    public boolean isEmptyStringEqualToNull() {
        return false;
    }

    public boolean isEmulatingSequences() {
        return false;
    }

    public boolean isFastInTransaction() {
        return false;
    }

    public boolean isIdentitySupported() {
        return true;
    }

    public boolean isNextSequenceValueInInsertSupported() {
        return !this.isEmulatingSequences();
    }

    public boolean isSchemaSupported() {
        return true;
    }

    public boolean isSelectFromSameTableInInsertSupported() {
        return true;
    }

    public boolean isSequenceInWhereSupported() {
        return this.isSequenceSupported();
    }

    public boolean isSequenceSupported() {
        return true;
    }

    public boolean isSettingIdentityAllowed() {
        return true;
    }

    public String quoteIdentifier(String name) {
        return '\"' + name.replace("\"", "\"\"") + '\"';
    }

    public String quoteString(String value) {
        if (value.length() == 0) {
            return "''";
        }
        StringBuilder result = new StringBuilder(value.length() + 2);
        int start = 0;
        boolean isOpen = false;
        String concatOperator = this.getConcatOperator();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < ' ') {
                if (i > 0) {
                    GeneratorDialect.finishPart(result, value, start, i, isOpen, true, concatOperator);
                    isOpen = false;
                    result.append(concatOperator);
                }
                this.addQuotedCharacter(result, c);
            } else {
                if (c != '\'') continue;
                GeneratorDialect.finishPart(result, value, start, i, isOpen, false, concatOperator);
                isOpen = true;
                result.append("''");
            }
            start = i + 1;
        }
        GeneratorDialect.finishPart(result, value, start, value.length(), isOpen, true, concatOperator);
        return result.toString();
    }

    public void truncateTable(StatementsWriter writer, GeneratorTable table) throws IOException {
        writer.writePlainStatement(this, "TRUNCATE TABLE " + table.getQualifiedName());
    }

    @Generated
    public char[] getLetter() {
        return this.letter;
    }
}

