/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import org.fastnate.generator.dialect.GeneratorDialect;

public class MySqlDialect
extends GeneratorDialect {
    private static final char MAX_ESCAPE = '\\';
    private static final String[] ESCAPES = new String[93];

    @Override
    protected String createAddDateExpression(String referenceDate, long value, String unit) {
        return "DATE_ADD(" + referenceDate + ", INTERVAL " + value + ' ' + unit + ')';
    }

    @Override
    public String createBlobExpression(byte[] blob) {
        return this.createHexBlobExpression("x'", blob, "'");
    }

    @Override
    public Object getEmptyValuesExpression() {
        return "VALUES ()";
    }

    @Override
    public String getOptionalTable() {
        return "FROM DUAL";
    }

    @Override
    public boolean isEmulatingSequences() {
        return true;
    }

    @Override
    public boolean isFastInTransaction() {
        return true;
    }

    @Override
    public boolean isSchemaSupported() {
        return false;
    }

    @Override
    public boolean isSelectFromSameTableInInsertSupported() {
        return false;
    }

    @Override
    public String quoteIdentifier(String name) {
        return '`' + name + '`';
    }

    @Override
    public String quoteString(String value) {
        if (value.length() == 0) {
            return "''";
        }
        StringBuilder result = new StringBuilder(value.length() + 2).append('\'');
        for (int i = 0; i < value.length(); ++i) {
            String escape;
            char c = value.charAt(i);
            if (c <= '\\' && (escape = ESCAPES[c]) != null) {
                result.append(escape);
                continue;
            }
            result.append(c);
        }
        return result.append('\'').toString();
    }

    static {
        MySqlDialect.ESCAPES[0] = "\\0";
        MySqlDialect.ESCAPES[8] = "\\b";
        MySqlDialect.ESCAPES[9] = "\\t";
        MySqlDialect.ESCAPES[10] = "\\n";
        MySqlDialect.ESCAPES[13] = "\\r";
        MySqlDialect.ESCAPES[26] = "\\Z";
        MySqlDialect.ESCAPES[39] = "''";
        MySqlDialect.ESCAPES[92] = "\\\\";
    }
}

