/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import java.io.IOException;
import java.util.Date;
import javax.persistence.TemporalType;
import org.fastnate.generator.RelativeDate;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.StatementsWriter;

public class OracleDialect
extends GeneratorDialect {
    private static final int MAX_VARCHAR_LENGTH = 2000;
    private static final int MAX_BLOB_LENGTH = 2000;

    @Override
    public void adjustNextSequenceValue(StatementsWriter writer, String sequenceName, long currentSequenceValue, long nextSequenceValue, int incrementSize) throws IOException {
        writer.writePlainStatement(this, "ALTER SEQUENCE " + sequenceName + " INCREMENT BY " + (nextSequenceValue - currentSequenceValue - (long)incrementSize));
        writer.writePlainStatement(this, "SELECT " + sequenceName + ".nextval FROM dual");
        writer.writePlainStatement(this, "ALTER SEQUENCE " + sequenceName + " INCREMENT BY " + incrementSize);
    }

    @Override
    public String buildCurrentSequenceValue(String sequence, int incrementSize, boolean firstCall) {
        if (this.isEmulatingSequences()) {
            return super.buildCurrentSequenceValue(sequence, incrementSize, firstCall);
        }
        if (firstCall) {
            return "(SELECT last_number FROM user_sequences WHERE sequence_name = " + this.quoteString(sequence) + ')';
        }
        return sequence + ".currval";
    }

    @Override
    public String buildNextSequenceValue(String sequence, int incrementSize) {
        return sequence + ".nextval";
    }

    @Override
    public String convertTemporalValue(Date value, TemporalType type) {
        String expression = super.convertTemporalValue(value, type);
        if (value instanceof RelativeDate.ReferenceDate || value instanceof RelativeDate) {
            return expression;
        }
        switch (type) {
            case DATE: {
                return "to_date(" + expression + ", 'YYYY-MM-DD')";
            }
            case TIME: {
                return "to_date(" + expression + ", 'HH24:MI:SS')";
            }
        }
        return "to_timestamp(" + expression + ", 'YYYY-MM-DD HH24:MI:SS.FF9')";
    }

    @Override
    protected String createAddDateExpression(String referenceDate, long value, String unit) {
        long abs = Math.abs(value);
        int digits = (int)Math.ceil(Math.log10(abs));
        return referenceDate + ' ' + (value < 0L ? (char)'-' : '+') + " INTERVAL '" + abs + "' " + unit + '(' + digits + ')';
    }

    @Override
    public String createBlobExpression(byte[] blob) {
        if (blob.length > 2000) {
            throw new IllegalArgumentException("Can't handle BLOB values with more than 2000 bytes (given BLOB had " + blob.length + " bytes)");
        }
        return this.createHexBlobExpression("hextoraw('", blob, "')");
    }

    @Override
    public String getOptionalTable() {
        return "FROM DUAL";
    }

    @Override
    public boolean isEmptyStringEqualToNull() {
        return true;
    }

    @Override
    public boolean isFastInTransaction() {
        return true;
    }

    @Override
    public boolean isIdentitySupported() {
        return false;
    }

    @Override
    public boolean isSequenceInWhereSupported() {
        return false;
    }

    @Override
    public String quoteString(String value) {
        if (value.length() > 2000) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < value.length(); i += 2000) {
                if (i > 0) {
                    result.append(" || ");
                }
                result.append("TO_CLOB(").append(super.quoteString(value.substring(i, Math.min(value.length(), i + 2000)))).append(')');
            }
            return result.toString();
        }
        return super.quoteString(value);
    }
}

