/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import java.io.IOException;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.StatementsWriter;

public class PostgresDialect
extends GeneratorDialect {
    @Override
    protected void addQuotedCharacter(StringBuilder result, char c) {
        if (c == '\u0000') {
            throw new IllegalArgumentException("PostgreSQL does not support '\\0' characters");
        }
        super.addQuotedCharacter(result, c);
    }

    @Override
    public void adjustNextIdentityValue(StatementsWriter writer, GeneratorTable table, GeneratorColumn columnName, long nextValue) throws IOException {
        writer.writePlainStatement(this, "ALTER SEQUENCE " + table.getName() + "_id_seq RESTART WITH " + nextValue);
    }

    @Override
    public String buildCurrentSequenceValue(String sequence, int incrementSize, boolean firstCall) {
        if (firstCall && !this.isEmulatingSequences()) {
            return "(SELECT last_value - (CASE WHEN is_called THEN 0 ELSE " + incrementSize + " END) FROM " + sequence + ')';
        }
        return super.buildCurrentSequenceValue(sequence, incrementSize, firstCall);
    }

    @Override
    public String convertBooleanValue(boolean value) {
        return value ? "true" : "false";
    }

    @Override
    protected String createAddDateExpression(String referenceDate, long value, String unit) {
        return referenceDate + ' ' + (value < 0L ? (char)'-' : '+') + " INTERVAL '" + Math.abs(value) + ' ' + unit + '\'';
    }

    @Override
    public String createBlobExpression(byte[] blob) {
        return this.createHexBlobExpression("decode('", blob, "', 'hex')");
    }

    @Override
    public void truncateTable(StatementsWriter writer, GeneratorTable table) throws IOException {
        writer.writePlainStatement(this, "TRUNCATE TABLE " + table.getQualifiedName() + " CASCADE");
    }
}

