/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public abstract class AbstractStatementsWriter
implements StatementsWriter {
    @Override
    public void close() throws IOException {
    }

    @Override
    public TableStatement createInsertStatement(GeneratorDialect dialect, GeneratorTable table) {
        return new InsertStatement(dialect, table);
    }

    @Override
    public EntityStatement createPlainStatement(GeneratorDialect dialect, String sql) {
        return new PlainStatement(sql);
    }

    @Override
    public TableStatement createUpdateStatement(GeneratorDialect dialect, GeneratorTable table, GeneratorColumn idColumn, ColumnExpression idValue) {
        return new UpdateStatement(dialect, table, idColumn, idValue);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void writeComment(String comment) throws IOException {
    }

    @Override
    public void writeSectionSeparator() throws IOException {
    }

    protected static class UpdateStatement
    extends AbstractTableStatement {
        private final GeneratorColumn idColumn;
        private final ColumnExpression idValue;

        protected UpdateStatement(GeneratorDialect dialect, GeneratorTable table, GeneratorColumn idColumn, ColumnExpression idValue) {
            super(dialect, table);
            this.idColumn = idColumn;
            this.idValue = idValue;
        }

        @Override
        public String toSql() {
            StringBuilder result = new StringBuilder("UPDATE ").append(this.getTable().getQualifiedName()).append(" SET ");
            Iterator<Map.Entry<GeneratorColumn, ColumnExpression>> entries = this.getValues().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<GeneratorColumn, ColumnExpression> entry = entries.next();
                result.append(entry.getKey().getQualifiedName()).append(" = ");
                entry.getValue().appendSql(result);
                if (!entries.hasNext()) continue;
                result.append(", ");
            }
            result.append(" WHERE ").append(this.idColumn.getQualifiedName()).append(" = ");
            this.idValue.appendSql(result);
            return result.toString();
        }

        @Generated
        public GeneratorColumn getIdColumn() {
            return this.idColumn;
        }

        @Generated
        public ColumnExpression getIdValue() {
            return this.idValue;
        }
    }

    protected static class PlainStatement
    implements EntityStatement {
        private final String sql;

        @Override
        public String toSql() {
            return this.sql;
        }

        public String toString() {
            return this.sql;
        }

        @Generated
        public PlainStatement(String sql) {
            this.sql = sql;
        }
    }

    protected static class InsertStatement
    extends AbstractTableStatement {
        public InsertStatement(GeneratorDialect dialect, GeneratorTable table) {
            super(dialect, table);
        }

        protected <T> StringBuilder addColumns(StringBuilder result, Collection<T> columns, BiConsumer<StringBuilder, T> mapper) {
            Iterator<T> it = columns.iterator();
            if (it.hasNext()) {
                mapper.accept(result, (StringBuilder)it.next());
            }
            while (it.hasNext()) {
                result.append(", ");
                mapper.accept(result, (StringBuilder)it.next());
            }
            return result;
        }

        @Override
        public String toSql() {
            StringBuilder result = new StringBuilder("INSERT INTO ").append(this.getTable().getQualifiedName());
            if (this.getValues().isEmpty()) {
                result.append(' ').append(this.getDialect().getEmptyValuesExpression());
            } else {
                result.append(" (");
                if (!this.getDialect().isSelectFromSameTableInInsertSupported() && this.isPlainExpressionAvailable()) {
                    Pattern subselectPattern = Pattern.compile("\\(SELECT\\s+(.*)\\s+FROM\\s+" + this.getTable().getQualifiedName() + "\\s*\\)", 2);
                    if (this.getValues().values().stream().anyMatch(value -> !(value instanceof PrimitiveColumnExpression) && subselectPattern.matcher(value.toSql()).matches())) {
                        this.addColumns(result, this.getValues().keySet(), (sb, column) -> sb.append(column.getQualifiedName())).append(") SELECT ");
                        this.addColumns(result, this.getValues().values(), (sb, value) -> {
                            Matcher matcher;
                            String sql = value.toSql();
                            if (!(value instanceof PrimitiveColumnExpression) && (matcher = subselectPattern.matcher(sql)).matches()) {
                                sb.append(matcher.group(1));
                            } else {
                                sb.append(sql);
                            }
                        }).append(" FROM ").append(this.getTable().getQualifiedName());
                        return result.toString();
                    }
                }
                this.addColumns(result, this.getValues().keySet(), (sb, column) -> sb.append(column.getQualifiedName())).append(") VALUES (");
                this.addColumns(result, this.getValues().values(), (sb, column) -> column.appendSql(result));
                result.append(')');
            }
            return result.toString();
        }
    }

    protected static abstract class AbstractTableStatement
    implements TableStatement {
        private final GeneratorDialect dialect;
        private final GeneratorTable table;
        private final Map<GeneratorColumn, ColumnExpression> values = new LinkedHashMap<GeneratorColumn, ColumnExpression>();
        private boolean plainExpressionAvailable;

        public void reset() {
            this.plainExpressionAvailable = false;
            this.values.clear();
        }

        @Override
        public void setColumnValue(GeneratorColumn column, ColumnExpression value) {
            if (value == null) {
                throw new NullPointerException("value should be not null");
            }
            if (this.values.put(column, value) != null) {
                throw new IllegalArgumentException("A value for " + column.getName() + " was assigned twice");
            }
            if (!this.plainExpressionAvailable && !(value instanceof PrimitiveColumnExpression)) {
                this.plainExpressionAvailable = true;
            }
        }

        public String toString() {
            return this.toSql();
        }

        @Generated
        public GeneratorDialect getDialect() {
            return this.dialect;
        }

        @Override
        @Generated
        public GeneratorTable getTable() {
            return this.table;
        }

        @Generated
        public Map<GeneratorColumn, ColumnExpression> getValues() {
            return this.values;
        }

        @Generated
        public boolean isPlainExpressionAvailable() {
            return this.plainExpressionAvailable;
        }

        @Generated
        public AbstractTableStatement(GeneratorDialect dialect, GeneratorTable table) {
            this.dialect = dialect;
            this.table = table;
        }
    }
}

