/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import java.util.function.Function;
import lombok.Generated;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;

public class PrimitiveColumnExpression<T>
implements ColumnExpression {
    public static final PrimitiveColumnExpression<Object> NULL = new PrimitiveColumnExpression<Object>(null, t -> "null");
    private final T value;
    private final T databaseValue;
    private final Function<T, String> converter;

    public static final <N extends Number> PrimitiveColumnExpression<N> create(N value, GeneratorDialect dialect) {
        return new PrimitiveColumnExpression<Number>(value, value, dialect::convertNumberValue);
    }

    public static final PrimitiveColumnExpression<String> create(String value, GeneratorDialect dialect) {
        return new PrimitiveColumnExpression<String>(value, value, dialect::quoteString);
    }

    public PrimitiveColumnExpression(T value, Function<T, String> converter) {
        this(value, value, converter);
    }

    @Override
    public String toSql() {
        return this.converter.apply(this.value);
    }

    public String toString() {
        return this.toSql();
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public T getDatabaseValue() {
        return this.databaseValue;
    }

    @Generated
    public Function<T, String> getConverter() {
        return this.converter;
    }

    @Generated
    public PrimitiveColumnExpression(T value, T databaseValue, Function<T, String> converter) {
        this.value = value;
        this.databaseValue = databaseValue;
        this.converter = converter;
    }
}

