/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.fastnate.data.DataChangeDetector;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="import-data", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ImportDataMojo
extends AbstractMojo {
    private static final String SETTINGS_KEY = String.valueOf(ImportDataMojo.class.getName()) + ".settings";
    @Component
    private BuildContext context;
    @Component
    private MavenProject project;
    @Component
    private PluginDescriptor descriptor;
    @Parameter
    private String dialect;
    @Parameter
    private String packages;
    @Parameter(defaultValue="${basedir}/src/main/data")
    private File dataFolder;
    @Parameter(defaultValue="${project.build.outputDirectory}/data.sql")
    private File sqlFile;
    @Parameter(defaultValue="UTF-8")
    private String encoding;
    @Parameter
    private String prefix;
    @Parameter
    private String postfix;
    @Parameter
    private DataChangeDetector changeDetector;
    @Parameter
    private Map<String, String> additionalSettings;

    private static void addProperty(Properties settings, String key, String value) {
        if (value != null) {
            settings.put(key, value);
        }
    }

    private static boolean isAnnotationPresent(Class<?> c, Class<? extends Annotation> ... annotations) {
        Class<? extends Annotation>[] classArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> annotation = classArray[n2];
            if (c.isAnnotationPresent(annotation)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private URLClassLoader buildClassLoader() throws MojoExecutionException {
        ArrayList<URL> projectClasspathList = new ArrayList<URL>();
        try {
            for (Object element : this.project.getCompileClasspathElements()) {
                try {
                    projectClasspathList.add(new File(element.toString()).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(element + " is an invalid classpath element", (Exception)e);
                }
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not find project dependencies", (Exception)((Object)e));
        }
        return new URLClassLoader(projectClasspathList.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private boolean detectChanges(Properties newSettings, File outputFile) {
        if (!outputFile.isFile()) {
            this.getLog().debug((CharSequence)"detectChanges(): Missing output file");
            return true;
        }
        Properties oldSettings = (Properties)this.context.getValue(SETTINGS_KEY);
        if (!newSettings.equals(oldSettings)) {
            if (oldSettings != null) {
                this.getLog().debug((CharSequence)"detectChanges(): Changed settings");
            } else {
                this.getLog().debug((CharSequence)"detectChanges(): No previous run");
            }
            this.context.setValue(SETTINGS_KEY, newSettings.clone());
            return true;
        }
        if (this.detectFilePropertyChanges(newSettings, "fastnate.data.sql.prefix", outputFile) || this.detectFilePropertyChanges(newSettings, "fastnate.data.sql.postfix", outputFile)) {
            this.getLog().debug((CharSequence)"detectChanges(): pre-/ or postfix changed");
            return true;
        }
        String dataFolderPath = newSettings.getProperty("fastnate.data.folder");
        if (dataFolderPath != null) {
            Scanner dataFolderScanner = this.context.newScanner(new File(dataFolderPath));
            dataFolderScanner.scan();
            if (dataFolderScanner.getIncludedDirectories().length > 0 || dataFolderScanner.getIncludedFiles().length > 0) {
                this.getLog().debug((CharSequence)"detectChanges(): data folder changed");
                return true;
            }
        }
        if (this.detectRelevantFileChanges()) {
            return true;
        }
        this.getLog().debug((CharSequence)"detectChanges(): No changes detected");
        return false;
    }

    private boolean detectFilePropertyChanges(Properties properties, String key, File outputFile) {
        String propertyValue = StringUtils.trimToNull((String)properties.getProperty(key));
        if (propertyValue == null) {
            return false;
        }
        if (propertyValue.endsWith(".sql")) {
            String[] fileNames;
            String[] stringArray = fileNames = propertyValue.split("[\\n\\" + File.pathSeparatorChar + ",;]+");
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File file = new File(fileName);
                if (this.context.hasDelta(file) && !this.context.isUptodate(outputFile, file)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean detectRelevantClassFileChanges() {
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        Scanner scanner = this.context.newScanner(outputDirectory);
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        if (scanner.getIncludedFiles().length > 0) {
            Class<?> mappedSuperClass;
            Class<?> embeddableClass;
            Class<?> entityClass;
            Class<?> dataProviderClass;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                dataProviderClass = classLoader.loadClass("org.fastnate.data.DataProvider");
                entityClass = classLoader.loadClass("javax.persistence.Entity");
                embeddableClass = classLoader.loadClass("javax.persistence.Embeddable");
                mappedSuperClass = classLoader.loadClass("javax.persistence.MappedSuperclass");
            }
            catch (ClassNotFoundException e) {
                this.getLog().warn((CharSequence)"Missing JPA or fastnate-data dependency", (Throwable)e);
                return false;
            }
            String[] stringArray = scanner.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c;
                block8: {
                    String file = stringArray[n2];
                    c = classLoader.loadClass(file.replace('\\', '.').replace('/', '.').substring(0, file.length() - ".class".length()));
                    if (!dataProviderClass.isAssignableFrom(c)) break block8;
                    this.getLog().debug((CharSequence)"detectChanges(): data provider changed");
                    return true;
                }
                try {
                    if (ImportDataMojo.isAnnotationPresent(c, entityClass, mappedSuperClass, embeddableClass)) {
                        this.getLog().debug((CharSequence)"detectChanges(): JPA class changed");
                        return true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean detectRelevantFileChanges() {
        if (this.detectRelevantClassFileChanges()) {
            return true;
        }
        if (this.changeDetector != null) {
            List sourceRoots = this.project.getCompileSourceRoots();
            for (String sourceRoot : sourceRoots) {
                String[] includedFiles;
                Scanner sourceFolderScanner = this.context.newScanner(new File(sourceRoot));
                sourceFolderScanner.scan();
                String[] stringArray = includedFiles = sourceFolderScanner.getIncludedFiles();
                int n = includedFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    if (this.changeDetector.isDataFile(new File(file))) {
                        this.getLog().debug((CharSequence)("detectChanges(): change detector fired for " + file));
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        block27: {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (URLClassLoader classloader = this.buildClassLoader();){
                        Thread.currentThread().setContextClassLoader(classloader);
                        Properties settings = new Properties();
                        ImportDataMojo.addProperty(settings, "fastnate.data.folder", this.dataFolder.getPath());
                        ImportDataMojo.addProperty(settings, "fastnate.data.sql.output.file", this.sqlFile.getPath());
                        ImportDataMojo.addProperty(settings, "fastnate.data.sql.output.encoding", this.encoding);
                        if (this.additionalSettings != null) {
                            settings.putAll(this.additionalSettings);
                        }
                        ImportDataMojo.addProperty(settings, "fastnate.generator.dialect", this.dialect);
                        ImportDataMojo.addProperty(settings, "fastnate.data.provider.packages", this.packages);
                        ImportDataMojo.addProperty(settings, "fastnate.data.sql.prefix", this.prefix);
                        ImportDataMojo.addProperty(settings, "fastnate.data.sql.postfix", this.postfix);
                        File outputFile = new File(settings.getProperty("fastnate.data.sql.output.file", "data.sql"));
                        if (!this.detectChanges(settings, outputFile)) break block27;
                        if (settings.getProperty("fastnate.generator.dialect") == null) {
                            this.getLog().warn((CharSequence)"No explicit database dialect specified, using default: H2");
                            settings.setProperty("fastnate.generator.dialect", "H2Dialect");
                        }
                        String outputEncoding = settings.getProperty("fastnate.data.sql.output.encoding", "UTF-8");
                        this.getLog().info((CharSequence)("Writing entities to " + outputFile + " with encoding " + outputEncoding));
                        try {
                            Throwable throwable2 = null;
                            Object var9_14 = null;
                            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.context.newFileOutputStream(outputFile), Charset.forName(outputEncoding)));){
                                Class<?> importerClass = Thread.currentThread().getContextClassLoader().loadClass("org.fastnate.data.EntityImporter");
                                Object importer = importerClass.getConstructor(settings.getClass()).newInstance(settings);
                                importerClass.getMethod("importData", Writer.class).invoke(importer, writer);
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (IOException | ReflectiveOperationException | RuntimeException e) {
                            this.getLog().error((CharSequence)("Could not generate SQL file: " + this.sqlFile), (Throwable)e);
                            throw new MojoExecutionException("Could not generate SQL file: " + this.sqlFile, e);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not create class loader: " + e, (Exception)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }
}

